﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace ns {
    namespace detail {
        class IGameCardStopper;
    }

    class GameCardStopper
    {
        NN_DISALLOW_COPY(GameCardStopper);

    public:
        /**
        * @brief コンストラクタです。
        */
        GameCardStopper() NN_NOEXCEPT;

        explicit GameCardStopper(sf::SharedPointer<detail::IGameCardStopper> interface) NN_NOEXCEPT;

        explicit GameCardStopper(GameCardStopper&& rvalue) NN_NOEXCEPT;

        GameCardStopper& operator=(GameCardStopper&& rvalue) NN_NOEXCEPT;

        void swap(GameCardStopper& other) NN_NOEXCEPT;

    private:
        sf::SharedPointer<detail::IGameCardStopper> m_Interface;
    };
}} // ~nn::ns
