﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>
#include <nn/sf/sf_Types.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ns/ns_AppletLauncherApi.h>
#include <nn/ns/ns_ApplicationLaunchInfo.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ncm/ncm_InstallTaskBase.h>
#include <nn/settings/settings_Language.h>
#include <nn/nim/nim_BackgroundDownloadStressTaskInfo.h>
#include <nn/ns/ns_GameCardStopper.h>
#include <nn/ns/ns_RequestServerStopper.h>
#include <nn/ns/ns_ApplicationRightsTypes.h>

namespace nn { namespace ns {

    namespace detail {
        class IServiceGetterInterface;
    }

    void InitializeServiceGetterWithObject(sf::SharedPointer<nn::ns::detail::IServiceGetterInterface> interfac) NN_NOEXCEPT;

    // アプリケーションが持つコンテンツの中から一番最初に起動すべきプログラムを起動する
    Result LaunchApplication(os::ProcessId* outValue, ncm::ApplicationId id) NN_NOEXCEPT;

    // アプリケーションが持つコンテンツの中から指定した ProgramIndex のプログラムを起動する
    Result LaunchApplication(os::ProcessId* outValue, ncm::ApplicationId id, uint8_t programIndex) NN_NOEXCEPT;

    // ApplicationLaunchInfo を用いてプログラムを起動する
    Result LaunchApplication(os::ProcessId* outValue, const ApplicationLaunchInfo& info, uint8_t programIndex) NN_NOEXCEPT;

    Result LaunchLibraryApplet(os::ProcessId* outValue, ncm::SystemProgramId id) NN_NOEXCEPT;

    Result TerminateApplication(os::ProcessId pid) NN_NOEXCEPT;

    Result TerminateLibraryApplet(os::ProcessId pid) NN_NOEXCEPT;

    Result BeginInstallApplication(ncm::ApplicationId id, std::uint32_t version, ncm::StorageId storage) NN_NOEXCEPT;

    Result PushDownloadTaskList(const void* buffer, size_t size) NN_NOEXCEPT;

    void GetGameCardAttachmentEvent(os::SystemEvent* pOutEvent) NN_NOEXCEPT;

    struct GameCardAttachmentInfo
    {
        int64_t sequence;
        bool isAttached;
        Bit8 reserved[7];
    };

    void GetGameCardAttachmentInfo(GameCardAttachmentInfo* pOutInfo) NN_NOEXCEPT;

    void GetSdCardRemovedEvent(os::SystemEvent* pOutEvent) NN_NOEXCEPT;

    settings::LanguageCode GetApplicationSupportedLanguage(Bit32 supportedLanguageFlag) NN_NOEXCEPT;

    Result GetBackgroundDownloadStressTaskInfo(nim::BackgroundDownloadStressTaskInfo* outValue) NN_NOEXCEPT;

    Result GetBackgroundApplyDeltaStressTaskInfo(nim::BackgroundDownloadStressTaskInfo* outValue) NN_NOEXCEPT;

    void GetGameCardStopper(GameCardStopper* outValue) NN_NOEXCEPT;

    void GetRequestServerStopper(RequestServerStopper* outValue) NN_NOEXCEPT;

    Result GetStorageSize(int64_t* pOutTotalSize, int64_t* pOutFreeSpaceSize, ncm::StorageId storage) NN_NOEXCEPT;

    sf::NativeHandle GetDynamicCommitEvent() NN_NOEXCEPT;

    Result BoostSystemMemoryResourceLimit(int64_t boostSize) NN_NOEXCEPT;

    void EnableApplicationCrashReport(bool isEnabled) NN_NOEXCEPT;

    bool IsApplicationCrashReportEnabled() NN_NOEXCEPT;

    void EnableApplicationAllThreadDumpOnCrash(bool isEnabled) NN_NOEXCEPT;

    Result GetMainApplicationProgramIndex(uint8_t* outValue, ncm::ApplicationId id) NN_NOEXCEPT;

    Result GetMainApplicationProgramIndex(uint8_t* outValue, const ApplicationLaunchInfo& info) NN_NOEXCEPT;

    Result GetApplicationLaunchInfo(ApplicationLaunchInfo* outValue, ncm::ApplicationId id) NN_NOEXCEPT;

    Result AcquireApplicationLaunchInfo(ApplicationLaunchInfo* outValue, os::ProcessId processId) NN_NOEXCEPT;

    // RightsEnvironment

    Result CreateRightsEnvironment(RightsEnvironmentHandle* pOut) NN_NOEXCEPT;
    void DestroyRightsEnvironment(RightsEnvironmentHandle handle) NN_NOEXCEPT;

    Result AddTargetApplicationToRightsEnvironment(RightsEnvironmentHandle handle, ncm::ApplicationId applicationId) NN_NOEXCEPT;
    Result SetUsersToRightsEnvironment(RightsEnvironmentHandle handle, bool anyUser, util::Span<const account::Uid> uids) NN_NOEXCEPT;

    Result ActivateRightsEnvironment(RightsEnvironmentHandle handle) NN_NOEXCEPT;
    void DeactivateRightsEnvironment(RightsEnvironmentHandle handle) NN_NOEXCEPT;

    Result GetRightsEnvironmentStatus(RightsEnvironmentStatus* pOut, RightsEnvironmentHandle handle) NN_NOEXCEPT;

}}  // namespace nn::ns
