﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace ns {

struct ApplicationEntityFlagTag{};
typedef util::BitFlagSet<32, ApplicationEntityFlagTag> ApplicationEntityFlag;

typedef ApplicationEntityFlag::Flag<0>      ApplicationEntityFlag_Application;
typedef ApplicationEntityFlag::Flag<1>      ApplicationEntityFlag_AddOnContent;
typedef ApplicationEntityFlag::Flag<2>      ApplicationEntityFlag_Patch;
typedef ApplicationEntityFlag::Flag<30>     ApplicationEntityFlag_SkipRunningCheck;
typedef ApplicationEntityFlag::Flag<31>     ApplicationEntityFlag_SkipGameCardCheck;

const ApplicationEntityFlag ApplicationEntityFlag_All = ApplicationEntityFlag_Application::Mask |
                                                        ApplicationEntityFlag_AddOnContent::Mask |
                                                        ApplicationEntityFlag_Patch::Mask;

}}  // namespace nn::ns
