﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ns/ns_ApplicationEntitySystemTypes.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace ns {

Result DeleteApplicationContentEntities(ncm::ApplicationId id, ApplicationEntityFlag flags, ncm::StorageId) NN_NOEXCEPT;

// ApplicationEntityFlag_All が付いているかどうかは無視される
Result DeleteApplicationCompletelyForDebug(ncm::ApplicationId id, ApplicationEntityFlag flags) NN_NOEXCEPT;

Result CleanupUnrecordedApplicationEntity(ncm::ApplicationId id) NN_NOEXCEPT;

}}  // namespace nn::ns
