﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      ns モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_NS_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ns, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NS_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NS_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NS_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NS_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(ns, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NS_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ns, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NS_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ns, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NS_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ns, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NS_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(ns, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NS_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ns, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NS_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ns, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NS_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ns, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NS_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ns, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NS_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NS_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NS_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NS_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ns, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NS_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NS_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NS_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ns, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NS_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Trace, 0, format, args)
#define NN_DETAIL_NS_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Trace, 1, format, args)
#define NN_DETAIL_NS_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Trace, 2, format, args)
#define NN_DETAIL_NS_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Trace, 3, format, args)

#define NN_DETAIL_NS_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Info, 0, format, args)
#define NN_DETAIL_NS_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Info, 1, format, args)
#define NN_DETAIL_NS_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Info, 2, format, args)
#define NN_DETAIL_NS_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Info, 3, format, args)

#define NN_DETAIL_NS_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Warn, 0, format, args)
#define NN_DETAIL_NS_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Warn, 1, format, args)
#define NN_DETAIL_NS_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Warn, 2, format, args)
#define NN_DETAIL_NS_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Warn, 3, format, args)

#define NN_DETAIL_NS_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Error, 0, format, args)
#define NN_DETAIL_NS_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Error, 1, format, args)
#define NN_DETAIL_NS_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Error, 2, format, args)
#define NN_DETAIL_NS_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Error, 3, format, args)

#define NN_DETAIL_NS_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Fatal, 0, format, args)
#define NN_DETAIL_NS_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Fatal, 1, format, args)
#define NN_DETAIL_NS_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Fatal, 2, format, args)
#define NN_DETAIL_NS_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ns, Fatal, 3, format, args)

#define NN_DETAIL_NS_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ns, Trace, 0, text, length)
#define NN_DETAIL_NS_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Trace, 1, text, length)
#define NN_DETAIL_NS_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Trace, 2, text, length)
#define NN_DETAIL_NS_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Trace, 3, text, length)

#define NN_DETAIL_NS_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(ns, Info, 0, text, length)
#define NN_DETAIL_NS_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ns, Info, 1, text, length)
#define NN_DETAIL_NS_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ns, Info, 2, text, length)
#define NN_DETAIL_NS_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ns, Info, 3, text, length)

#define NN_DETAIL_NS_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(ns, Warn, 0, text, length)
#define NN_DETAIL_NS_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ns, Warn, 1, text, length)
#define NN_DETAIL_NS_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ns, Warn, 2, text, length)
#define NN_DETAIL_NS_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ns, Warn, 3, text, length)

#define NN_DETAIL_NS_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ns, Error, 0, text, length)
#define NN_DETAIL_NS_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Error, 1, text, length)
#define NN_DETAIL_NS_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Error, 2, text, length)
#define NN_DETAIL_NS_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Error, 3, text, length)

#define NN_DETAIL_NS_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ns, Fatal, 0, text, length)
#define NN_DETAIL_NS_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Fatal, 1, text, length)
#define NN_DETAIL_NS_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Fatal, 2, text, length)
#define NN_DETAIL_NS_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ns, Fatal, 3, text, length)
