﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/npns/npns_Result.h>
#include <nn/npns/npns_Statistics.h>
#include <nn/npns/npns_StatisticsCollection.h>
#include <nn/nn_Common.h>

namespace nn
{
namespace npns
{
    const size_t UsernameLength = 64;
    const size_t PasswordLength = 64;
    struct Credential
    {
        char username[UsernameLength];
        char password[PasswordLength];
    };

    typedef StatisticsCollection<StatisticsDefinition> Statistics;

    const Bit64 ApplicationIdRaw = 0x010000000000002F;
}
}

