﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/ec/system/ec_VirtualAccountTypes.h>
#include <nn/nim/srv/nim_SimpleDataStore.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace nim { namespace srv {

    struct VirtualAccountDataEntry
    {
        account::Uid uid;
        ec::system::VirtualAccountId vaId;

        bool IsEmpty() NN_NOEXCEPT
        {
            return uid == account::InvalidUid;
        }

        void Set(const account::Uid& u, ec::system::VirtualAccountId v) NN_NOEXCEPT
        {
            uid = u;
            vaId = v;
        }

        void Clear() NN_NOEXCEPT
        {
            uid = account::InvalidUid;
            vaId = 0;
        }
    };

    struct VirtualAccountData
    {
        static const int MaxEntryCount = 64;
        VirtualAccountDataEntry entryList[MaxEntryCount];
    };

    class VirtualAccountStore : public SimpleDataStore<VirtualAccountData>
    {
    public:
        VirtualAccountStore() NN_NOEXCEPT : m_DataMutex(false) {}

        Result Register(const account::Uid& uid, ec::system::VirtualAccountId vaId) NN_NOEXCEPT;
        Result Unregister(const account::Uid& uid) NN_NOEXCEPT;
        Result Get(ec::system::VirtualAccountId* outValue, const account::Uid& uid) NN_NOEXCEPT;
        Result GetAccount(account::Uid* outValue, ec::system::VirtualAccountId vaId) NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;

    private:
        virtual void SetInitialData(VirtualAccountData* data) NN_NOEXCEPT;
        os::Mutex m_DataMutex;
    };
}}}
