﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/account.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/nim/nim_Result.h>
#include <nn/nim/nim_ShopServiceAccessTypes.h>
#include <nn/nim/nim_ShopServiceAccessConfig.h>
#include <nn/nim/detail/nim_IShopServiceAccessServer.sfdl.h>
#include <nn/nim/srv/nim_DeviceContext.h>

namespace nn { namespace nim { namespace srv {

/**
 * @brief   ショップサービスアクセスサーバー実装。
 */
class ShopServiceAccessServer
{
public:

    /**
     * @brief   リソースコンフィギュレーションエイリアス
     */
    typedef ShopServiceAccessConfiguration Configuration;

    /**
     * @brief   ショップサービスアクセスサーバー取得用ポートインタフェース。
     */
    class Interface
    {
    public:
        Result Initialize(DeviceContext* pContext) NN_NOEXCEPT;

        Result Finalize() NN_NOEXCEPT;

        // @brief   IPC:
        Result CreateServerInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessServer>> outValue, ::nn::Bit64 clientProcessId, ::nn::sf::NativeHandle inTransferHandle, uint64_t inTransferTotalSize) NN_NOEXCEPT;

        // @brief   IPC:
        Result RefreshDebugAvailability() NN_NOEXCEPT;

        // @brief   IPC:
        Result ClearDebugResponse() NN_NOEXCEPT;

        // @brief   IPC:
        Result RegisterDebugResponse(const ::nn::nim::ShopServiceAccessTypes::Server& inKeyTarget, const ::nn::sf::InArray<char>& inKeyPath, const ::nn::sf::InArray<char>& inResponseBody, const uint32_t inExpectResult, const uint32_t inHappenedRate) NN_NOEXCEPT;
    };
};

}}}
