﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_InstallTaskOccupiedSize.h>
#include <nn/nim/nim_BackgroundDownloadStressTaskInfo.h>
#include <nn/nim/nim_Config.h>
#include <nn/nim/detail/nim_IAsync.sfdl.h>
#include <nn/nim/detail/nim_INetworkInstallManager.sfdl.h>
#include <nn/nim/srv/nim_BackgroundDownloadStressTask.h>
#include <nn/nim/srv/nim_BackgroundApplyDeltaStressTask.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/nim/srv/nim_NetworkInstallTaskHolder.h>
#include <nn/nim/srv/nim_TaskDataStore.h>
#include <nn/nim/srv/nim_TemporaryDataStore.h>
#include <nn/ovln/ovln_SenderForOverlay.h>

namespace nn { namespace nim { namespace srv {
    class NetworkInstallManagerServer
    {
    public:
        Result Initialize(DeviceContext* deviceContext, DeviceAccountStore* deviceAccountStore, bool isMaintenanceOrSafeMode, bool isOvlnEnabled) NN_NOEXCEPT;

        Result CreateSystemUpdateTask(sf::Out<SystemUpdateTaskId> outValue, const ncm::ContentMetaKey& key, Bit32 config) NN_NOEXCEPT;
        Result DestroySystemUpdateTask(const SystemUpdateTaskId& id) NN_NOEXCEPT;
        Result ListSystemUpdateTask(sf::Out<std::int32_t> outCount, const sf::OutArray<SystemUpdateTaskId>& outList) NN_NOEXCEPT;
        Result RequestSystemUpdateTaskRun(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const SystemUpdateTaskId& id) NN_NOEXCEPT;
        Result GetSystemUpdateTaskInfo(sf::Out<nim::SystemUpdateTaskInfo> outValue, const SystemUpdateTaskId& id) NN_NOEXCEPT;
        Result CommitSystemUpdateTask(const SystemUpdateTaskId& id) NN_NOEXCEPT;

        Result CreateNetworkInstallTask(sf::Out<nim::NetworkInstallTaskId> outValue, ncm::ApplicationId appId, const sf::InArray<ncm::ContentMetaKey>& keyList, ncm::StorageId storage, Bit32 config) NN_NOEXCEPT;
        Result DestroyNetworkInstallTask(const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result ListNetworkInstallTask(sf::Out<std::int32_t> outCount, const sf::OutArray<nim::NetworkInstallTaskId>& outList) NN_NOEXCEPT;
        Result RequestNetworkInstallTaskRun(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result GetNetworkInstallTaskInfo(sf::Out<nim::NetworkInstallTaskInfo> outValue, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result ListNetworkInstallTaskContentMeta(sf::Out<std::int32_t> outCount, const sf::OutArray<ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result ListNetworkInstallTaskCommittedContentMeta(sf::Out<std::int32_t> outCount, const sf::OutArray<ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result ListNetworkInstallTaskNotCommittedContentMeta(sf::Out<std::int32_t> outCount, const sf::OutArray<ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result ListNetworkInstallTaskContentMetaFromInstallMeta(sf::Out<std::int32_t> outCount, const sf::OutArray<ncm::ContentMetaKey>& outList, std::int32_t offset, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;

        Result CommitNetworkInstallTask(const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result CommitNetworkInstallTaskPartially(const sf::InArray<ncm::StorageContentMetaKey>& keyList, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;

        Result ListApplicationNetworkInstallTask(sf::Out<std::int32_t> outCount, const sf::OutArray<nim::NetworkInstallTaskId>& outList, ncm::ApplicationId appId) NN_NOEXCEPT;
        Result SetNetworkInstallTaskAttribute(const NetworkInstallTaskIdAttribute& idAttribute) NN_NOEXCEPT;

        Result RequestLatestSystemUpdateMeta(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        Result RequestLatestVersion(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync, ncm::ApplicationId appId) NN_NOEXCEPT;
        Result AddNetworkInstallTaskContentMeta(const sf::InArray<ncm::ContentMetaKey>& list, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;

        Result GetDownloadedSystemDataPath(sf::Out<ncm::Path> outValue, ncm::SystemDataId dataId, const nim::SystemUpdateTaskId& taskId) NN_NOEXCEPT;
        Result CalculateNetworkInstallTaskRequiredSize(sf::Out<std::int64_t> outValue, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result CalculateNetworkInstallTaskContentsSize(sf::Out<std::int64_t> outValue, const nim::NetworkInstallTaskId& id, const ncm::ContentMetaKey& key, ncm::StorageId storageId) NN_NOEXCEPT;
        Result ListNetworkInstallTaskOccupiedSize(sf::Out<int> outCount, sf::OutArray<ncm::InstallTaskOccupiedSize> outList, int offset, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;

        Result IsExFatDriverIncluded(sf::Out<bool> outValue, const nim::SystemUpdateTaskId& id) NN_NOEXCEPT;

        Result GetBackgroundDownloadStressTaskInfo(sf::Out<BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;

        Result GetBackgroundApplyDeltaStressTaskInfo(sf::Out<BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;

        Result RequestDeviceAuthenticationToken(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;

        Result RequestGameCardRegistrationStatus(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const sf::InBuffer& token, const sf::InBuffer& cert) NN_NOEXCEPT;
        Result RequestRegisterGameCard(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const sf::InBuffer& token, const sf::InBuffer& cert, nim::GameCardRegistrationStatus status) NN_NOEXCEPT;

        Result RequestRegisterNotificationToken(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const npns::NotificationToken& notificationToken) NN_NOEXCEPT;

        Result RequestDownloadTaskList(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncData>> outAsync, const nim::ETag& eTag) NN_NOEXCEPT;
        Result RequestVersionList(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncData>> outAsync, const nim::ETag& eTag) NN_NOEXCEPT;

        Result RequestApplicationControl(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync, ncm::ApplicationId applicationId, std::uint32_t version) NN_NOEXCEPT;
        Result RequestLatestApplicationControl(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outAsync, ncm::ApplicationId applicationId) NN_NOEXCEPT;

        Result CreateApplyDeltaTask(sf::Out<nim::ApplyDeltaTaskId> outValue, ncm::ApplicationId appId, const ncm::ContentMetaKey& sourceKey, const sf::InArray<ncm::ContentMetaKey>& keyList, ncm::StorageId storageId) NN_NOEXCEPT;
        Result CreateApplyDeltaTaskFromDownloadTask(sf::Out<nim::ApplyDeltaTaskId> outValue, const NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result DestroyApplyDeltaTask(const nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        Result ListApplyDeltaTask(sf::Out<std::int32_t> outCount, const sf::OutArray<nim::ApplyDeltaTaskId>& outList) NN_NOEXCEPT;
        Result ListApplicationApplyDeltaTask(sf::Out<std::int32_t> outCount, const sf::OutArray<nim::ApplyDeltaTaskId>& outList, ncm::ApplicationId appId) NN_NOEXCEPT;
        Result RequestApplyDeltaTaskRun(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        Result ClearNotEnoughSpaceStateOfApplyDeltaTask(const ApplyDeltaTaskId& id) NN_NOEXCEPT;
        Result GetApplyDeltaTaskInfo(sf::Out<nim::ApplyDeltaTaskInfo> outValue, const nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        Result ListApplyDeltaTaskContentMeta(sf::Out<std::int32_t> outCount, const sf::OutArray<ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        Result CommitApplyDeltaTask(const nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        Result CalculateApplyDeltaTaskRequiredSize(sf::Out<std::int64_t> outValue, const nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        Result CalculateApplyDeltaTaskOccupiedSize(sf::Out<std::int64_t> outValue, const ApplyDeltaTaskId& id, ncm::StorageId storageId) NN_NOEXCEPT;
        Result GetApplyDeltaTaskRequiredStorage(sf::Out<ncm::StorageId> outValue, const nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;

        Result CreateLocalCommunicationReceiveApplicationTask(sf::Out<nim::LocalCommunicationReceiveApplicationTaskId> outValue, uint32_t ipv4, uint16_t port, ncm::ApplicationId appId, const sf::InArray<ncm::ContentMetaKey>& keyList, ncm::StorageId storage, Bit32 config) NN_NOEXCEPT;
        Result DestroyLocalCommunicationReceiveApplicationTask(const nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        Result ListLocalCommunicationReceiveApplicationTask(sf::Out<std::int32_t> outCount, const sf::OutArray<nim::LocalCommunicationReceiveApplicationTaskId>& outList) NN_NOEXCEPT;
        Result RequestLocalCommunicationReceiveApplicationTaskRun(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        Result GetLocalCommunicationReceiveApplicationTaskInfo(sf::Out<nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        Result ListLocalCommunicationReceiveApplicationTaskContentMeta(sf::Out<std::int32_t> outCount, const sf::OutArray<ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        Result CommitLocalCommunicationReceiveApplicationTask(const nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        Result ListApplicationLocalCommunicationReceiveApplicationTask(sf::Out<std::int32_t> outCount, const sf::OutArray<nim::LocalCommunicationReceiveApplicationTaskId>& outList, ncm::ApplicationId appId) NN_NOEXCEPT;
        Result GetLocalCommunicationReceiveApplicationTaskErrorContext(sf::Out<err::ErrorContext> outValue, const nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;

        Result CreateLocalCommunicationSendApplicationTask(sf::Out<nim::LocalCommunicationSendApplicationTaskId> outValue, uint32_t ipv4, uint16_t port, const sf::InArray<ncm::StorageContentMetaKey>& keyList, ncm::ApplicationId id) NN_NOEXCEPT;
        Result RequestLocalCommunicationSendApplicationTaskRun(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
        Result GetLocalCommunicationSendApplicationTaskInfo(sf::Out<nim::LocalCommunicationSendApplicationTaskInfo> outValue, const nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
        Result DestroyLocalCommunicationSendApplicationTask(const nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
        Result GetLocalCommunicationSendApplicationTaskErrorContext(sf::Out<err::ErrorContext> outValue, const nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
        Result CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(sf::Out<int64_t> outValue, const nim::LocalCommunicationReceiveApplicationTaskId id) NN_NOEXCEPT;
        Result ListApplicationLocalCommunicationSendApplicationTask(sf::Out<std::int32_t> outCount, const sf::OutArray<nim::LocalCommunicationSendApplicationTaskId>& outList, ncm::ApplicationId appId) NN_NOEXCEPT;

        Result CreateLocalCommunicationReceiveSystemUpdateTask(sf::Out<LocalCommunicationReceiveSystemUpdateTaskId> outValue, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key, Bit32 config) NN_NOEXCEPT;
        Result CreateLocalCommunicationReceiveSystemUpdateTaskForCleanup(LocalCommunicationReceiveSystemUpdateTaskId* outValue, const util::Uuid &uuid, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT;
        Result DestroyLocalCommunicationReceiveSystemUpdateTask(const LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result ListLocalCommunicationReceiveSystemUpdateTask(sf::Out<std::int32_t> outCount, const sf::OutArray<LocalCommunicationReceiveSystemUpdateTaskId>& outList) NN_NOEXCEPT;
        Result RequestLocalCommunicationReceiveSystemUpdateTaskRun(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result GetLocalCommunicationReceiveSystemUpdateTaskInfo(sf::Out<nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result CommitLocalCommunicationReceiveSystemUpdateTask(const LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result GetLocalCommunicationReceiveSystemUpdateTaskErrorContext(sf::Out<err::ErrorContext> outValue, const nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result GetReceivedSystemDataPath(sf::Out<ncm::Path> outValue, ncm::SystemDataId dataId, const LocalCommunicationReceiveSystemUpdateTaskId& taskId) NN_NOEXCEPT;

        Result CreateLocalCommunicationSendSystemUpdateTask(sf::Out<nim::LocalCommunicationSendSystemUpdateTaskId> outValue, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key) NN_NOEXCEPT;
        Result RequestLocalCommunicationSendSystemUpdateTaskRun(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outAsync, const nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result GetLocalCommunicationSendSystemUpdateTaskInfo(sf::Out<nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result DestroyLocalCommunicationSendSystemUpdateTask(const nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result GetLocalCommunicationSendSystemUpdateTaskErrorContext(sf::Out<err::ErrorContext> outValue, const nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
        Result ListLocalCommunicationSendSystemUpdateTask(sf::Out<std::int32_t> outCount, const sf::OutArray<nim::LocalCommunicationSendSystemUpdateTaskId>& outList) NN_NOEXCEPT;

        Result RequestQueryAvailableELicenses(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const sf::InArray<nn::es::RightsId>& rightsIds) NN_NOEXCEPT;
        Result RequestAssignELicenses(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const sf::InArray<nn::es::RightsId>& rightsIds, nn::nim::ELicenseType licenseType) NN_NOEXCEPT;
        Result RequestExtendELicenses(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
        Result RequestSyncELicenses(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outValue, const nn::account::NintendoAccountId& naId) NN_NOEXCEPT;
        Result RequestDownloadETickets(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outValue, const nn::account::Uid& uid, const sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
        Result RequestQueryRevokeReason(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncValue>> outValue, const nn::account::NintendoAccountId& naId, const nn::es::ELicenseId& eLicenseId) NN_NOEXCEPT;
        Result RequestReportActiveELicenses(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outValue, const nn::account::NintendoAccountId& naId, const sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
        Result RequestReportActiveELicensesPassively(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncResult>> outValue, const nn::account::NintendoAccountId& naId, const sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
        Result RequestRegisterDynamicRightsNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT;
        Result RequestAssignAllDeviceLinkedELicenses(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<nim::detail::IAsyncData>> outValue) NN_NOEXCEPT;

        Result PrepareShutdown() NN_NOEXCEPT;
        Result PrepareShutdownForSystemUpdate() NN_NOEXCEPT;

        Result FindMaxRequiredApplicationVersionOfTask(sf::Out<std::uint32_t> outValue, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        Result FindMaxRequiredSystemVersionOfTask(sf::Out<std::uint32_t> outValue, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;

        Result GetNetworkInstallTaskErrorContext(sf::Out<err::ErrorContext> outValue, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;

        void ReloadErrorSimulation() NN_NOEXCEPT;

    private:
        Result LoadFromSystemUpdateTaskStore() NN_NOEXCEPT;
        Result LoadFromNetworkInstallTaskStore() NN_NOEXCEPT;
        Result LoadFromApplyDeltaTaskStore() NN_NOEXCEPT;
        Result LoadFromLocalCommunicationTaskStoreToCleanup() NN_NOEXCEPT;
        Result LoadFromLocalCommunicationSystemUpdateTaskStoreToCleanup() NN_NOEXCEPT;
        Result CreateSystemUpdateTaskImpl(nim::SystemUpdateTaskId* outValue, const util::Uuid& uuid, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT;
        Result CreateNetworkInstallTaskImpl(nim::NetworkInstallTaskId* outValue, const util::Uuid& uuid, const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT;
        Result CreateApplyDeltaTaskImpl(nim::ApplyDeltaTaskId* outValue, const util::Uuid& uuid, const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT;
        Result CreateApplyDeltaTaskKeys(int* outKeys, ncm::StorageContentMetaKey* keys, int countKeys, NetworkInstallTaskId taskId) NN_NOEXCEPT;
        Result CreateLocalCommunicationReceiveApplicationTaskImpl(nim::LocalCommunicationReceiveApplicationTaskId* outValue, const util::Uuid& uuid, uint32_t ipv4, uint16_t port, const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT;
        Result CreateLocalCommunicationReceiveApplicationTaskForCleanup(nim::LocalCommunicationReceiveApplicationTaskId* outValue, const util::Uuid& uuid, const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT;
        Result CreateLocalCommunicationSendApplicationTaskImpl(nim::LocalCommunicationSendApplicationTaskId* outValue, const util::Uuid& uuid, uint32_t ipv4, uint16_t port, const ncm::StorageContentMetaKey keyList[], int listCount, ncm::ApplicationId id) NN_NOEXCEPT;
        Result CreateLocalCommunicationReceiveSystemUpdateTaskImpl(nim::LocalCommunicationReceiveSystemUpdateTaskId* outValue, const util::Uuid& uuid, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT;
        Result CreateLocalCommunicationSendSystemUpdateTaskImpl(nim::LocalCommunicationSendSystemUpdateTaskId* outValue, const util::Uuid& uuid, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key) NN_NOEXCEPT;
        Result FindTargetPatch(ncm::StorageContentMetaKey* outKey, ncm::ApplicationId id) NN_NOEXCEPT;
        Result SetupStressTask() NN_NOEXCEPT;

        TaskDataStore m_NetworkInstallTaskDataStore;
        TaskDataStore m_SystemUpdateTaskDataStore;
        TaskDataStore m_ApplyDeltaTaskDataStore;
        TaskDataStore m_LocalCommunicationReceiveApplicationTaskDataStore;
        TaskDataStore m_LocalCommunicationReceiveSystemUpdateTaskDataStore;
        TemporaryDataStore m_TemporaryDataStore;

        typedef TaskHolderManager<SystemUpdateTaskHolder, MaxSystemUpdateTaskCount> SystemUpdateTaskHolder;
        SystemUpdateTaskHolder m_SystemUpdateTaskHolder;
        typedef TaskHolderManager<NetworkInstallTaskHolder, MaxNetworkInstallTaskCount> NetworkInstallTaskHolder;
        NetworkInstallTaskHolder m_NetworkInstallTaskHolder;
        typedef TaskHolderManager<ApplyDeltaTaskHolder, MaxApplyDeltaTaskCount> ApplyDeltaTaskHolder;
        ApplyDeltaTaskHolder m_ApplyDeltaTaskHolder;
        typedef TaskHolderManager<LocalCommunicationReceiveApplicationTaskHolder, MaxLocalCommunicationReceiveApplicationTaskCount> LocalCommunicationReceiveApplicationTaskHolder;
        LocalCommunicationReceiveApplicationTaskHolder m_LocalCommunicationReceiveApplicationTaskHolder;
        typedef TaskHolderManager<LocalCommunicationSendApplicationTaskHolder, MaxLocalCommunicationSendApplicationTaskCount> LocalCommunicationSendApplicationTaskHolder;
        LocalCommunicationSendApplicationTaskHolder m_LocalCommunicationSendApplicationTaskHolder;
        typedef TaskHolderManager<LocalCommunicationReceiveSystemUpdateTaskHolder, MaxLocalCommunicationReceiveSystemUpdateTaskCount> LocalCommunicationReceiveSystemUpdateTaskHolder;
        LocalCommunicationReceiveSystemUpdateTaskHolder m_LocalCommunicationReceiveSystemUpdateTaskHolder;
        typedef TaskHolderManager<LocalCommunicationSendSystemUpdateTaskHolder, MaxLocalCommunicationSendSystemUpdateTaskCount> LocalCommunicationSendSystemUpdateTaskHolder;
        LocalCommunicationSendSystemUpdateTaskHolder m_LocalCommunicationSendSystemUpdateTaskHolder;

        // 現状利用されていないが将来の利用のために残しておく
        ovln::SenderForOverlayType m_Sender;

        DeviceContext* m_DeviceContext;
        DeviceAccountStore* m_DeviceAccountStore;

        BackgroundDownloadStressTask m_BackgroundDownloadStressTask;
        BackgroundApplyDeltaStressTask m_BackgroundApplyDeltaStressTask;
    };
}}}
