﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_InstallTaskBase.h>
#include <nn/ncm/ncm_ContentInfoData.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentMeta.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/nim/nim_LocalCommunicationSendContentProgress.h>
#include <nn/nim/srv/nim_LocalCommunicationConfig.h>
#include <nn/nim/srv/nim_LocalCommunicationDeliveryProtocol.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace nim { namespace srv {

    class LocalCommunicationSendContentTaskBase
    {
    public:
        LocalCommunicationSendContentTaskBase() NN_NOEXCEPT : m_CancelMutex(false) , m_ProgressMutex(false) {}

        //--------------------------------------------------------------------------
        //  AsyncTaskResultImpl で実行するために必要なメソッド
        //--------------------------------------------------------------------------
        void Cancel() NN_NOEXCEPT;
        void ResetCancel() NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result PrepareAndExecute() NN_NOEXCEPT;
        Result InitializeBeforeRun() NN_NOEXCEPT;
        void FinalizeAfterRun() NN_NOEXCEPT;
        void GetErrorContext(err::ErrorContext* outValue) const NN_NOEXCEPT
        {
            *outValue = m_ErrorContext;
        }

        void SetBuffer(void* buffer, size_t bufferSize) NN_NOEXCEPT
        {
            m_Buffer = static_cast<char*>(buffer);
            m_BufferSize = bufferSize;
        }

        LocalCommunicationSendContentProgress GetProgress() const NN_NOEXCEPT;

        Result Cleanup() NN_NOEXCEPT
        {
            // TORIAEZU: 何か必要だったら追加する
            NN_RESULT_SUCCESS;
        }

    protected:
        Result Initialize(uint32_t ipv4, uint16_t port) NN_NOEXCEPT;

        virtual Result GetPackagedContentInfo(ncm::PackagedContentInfo* outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT = 0;
        virtual Result GetStorage(ncm::StorageId* outValue, const ncm::ContentId& contentId) NN_NOEXCEPT = 0;

        Result GetPackagedContentInfoImpl(ncm::PackagedContentInfo* outValue, const ncm::ContentMetaKey& key, ncm::StorageId storageId) NN_NOEXCEPT;

        void SetTotalSize(int64_t totalSize) NN_NOEXCEPT;

    private:
        bool IsCancelRequested() const NN_NOEXCEPT;
        Result SetAndThrowLastResult(Result result) NN_NOEXCEPT;

        // TODO: Prepare でどこまでやるかを検討する (進捗に関係する)
        Result PrepareImpl() NN_NOEXCEPT;
        // TODO: Execute でどこまでやるかを検討する (進捗に関係する)
        Result ExecuteImpl() NN_NOEXCEPT;

        void AddProgress(int64_t progress) NN_NOEXCEPT;

        char* m_Buffer{};
        size_t m_BufferSize{};

        LocalCommunicationDeliveryProtocolServer m_Connection;
        err::ErrorContext m_ErrorContext{};

        mutable os::Mutex m_CancelMutex;
        bool m_CancelRequested{};

        mutable os::Mutex m_ProgressMutex;
        LocalCommunicationSendContentProgress m_Progress{};
        Result m_LastResult{};
    };
}}}
