﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_File.h>
#include <nn/ncm/ncm_ContentMetaExtendedData.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/nim/nim_LocalCommunicationReceiveApplicationTaskId.h>
#include <nn/nim/nim_LocalCommunicationReceiveApplicationTaskInfo.h>
#include <nn/nim/srv/nim_FileNetworkInstallTaskMeta.h>
#include <nn/nim/srv/nim_LocalCommunicationReceiveContentTaskBase.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace nim { namespace srv {

    class LocalCommunicationReceiveApplicationTask : public LocalCommunicationReceiveContentTaskBase
    {
    public:
        Result Initialize(uint32_t ipv4, uint16_t port, const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT;
        Result InitializeForCleanup(const char* metaFilePath, const char* dataFilePath) NN_NOEXCEPT;

        ncm::ApplicationId GetApplicationId() const NN_NOEXCEPT
        {
            return m_Meta.GetApplicationId();
        }
        virtual ncm::InstallProgress GetProgress() NN_NOEXCEPT NN_OVERRIDE;

    private:
        virtual int CountInstallContentMetaKey() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetInstallContentMetaKey(ncm::ContentMetaKey* outValue, int index) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result InstallTicket(const fs::RightsId& rightsId, ncm::ContentMetaType contentMetaType) NN_NOEXCEPT NN_OVERRIDE;

        FileNetworkInstallTaskMeta m_Meta;
        ncm::FileInstallTaskData m_Data;
    };
}}}
