﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>

#include <nn/nn_Common.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/os/os_Mutex.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace nim { namespace srv {

    namespace detail {

        //
        // 基本方針
        //
        // アラインメントは 4KiB でそろっている想定
        // 基本想定された振る舞いしかしないことを前提にするため、想定外の振る舞いは全て ABORT させる
        //

        static const size_t BufferAlign = 4096;
        static const size_t MemoryManagementAreaSize = BufferAlign; // 本来はもう少し少なくてもいいはずだが、アラインを揃えた値にしておく

        struct BufferFlagSetTag{};
        typedef util::BitFlagSet<32, BufferFlagSetTag> BufferFlagSet;

        class BufferInfo
        {
        public:
            BufferInfo(size_t memorySize, BufferFlagSet flag, BufferFlagSet groupFlagSet) NN_NOEXCEPT;

            size_t GetSize() const NN_NOEXCEPT;

            BufferFlagSet GetFlag() const NN_NOEXCEPT;

            BufferFlagSet GetGroup() const NN_NOEXCEPT;

        private:
            const size_t m_MemorySize;
            const BufferFlagSet m_Flag;
            const BufferFlagSet m_Group;
        };

        class BufferAllocator
        {
        public:
            BufferAllocator(void* buffer, size_t bufferSize, const BufferInfo** pList, int numInfo) NN_NOEXCEPT;

            ~BufferAllocator() NN_NOEXCEPT;

            void* Allocate(size_t* outSize, BufferFlagSet flag) NN_NOEXCEPT;

            void Free(void* buffer, BufferFlagSet flag) NN_NOEXCEPT;

        private:
            size_t CalculateGroupMemorySize(BufferFlagSet group) const NN_NOEXCEPT;
            const BufferInfo** m_pInfoList;
            const int m_NumInfo;
            BufferFlagSet m_AllocatedFlagSet;
            lmem::HeapHandle m_Handle;
            os::Mutex m_Mutex;
        };

    } // namespace detail
}}} // namespace nn::nim::srv
