﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ApplyDeltaProgress.h>

namespace nn { namespace nim {

enum class ApplyDownloadedDeltaProgressState : Bit8
{
    NotRunning,
    InitialPrepared,
    Applying,
    AllApplied,
    Commited,
    Suspended,
    NotEnoughSpace,
    Fatal,
};

struct ApplyDownloadedDeltaProgress
{
    int64_t                           applied;
    int64_t                           total;
    util::TypedStorage<Result, sizeof(Result), NN_ALIGNOF(Result)> lastResult;
    ApplyDownloadedDeltaProgressState state;
    Bit8                              reserved[3];
};

struct ApplyDeltaThroughput
{
    int64_t       processedSize;
    TimeSpanType  elapsedTime;
};

}}
