﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/nifm_TypesAccessPoint.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn
{
namespace nifm
{

struct PrivacyFlag
{
    using Open_None   = nn::util::BitFlagSet<8, PrivacyFlag>::Flag<0>; //!< 暗号化なし
    using Open_Wep    = nn::util::BitFlagSet<8, PrivacyFlag>::Flag<1>; //!< Open-WEP
    using Shared_Wep  = nn::util::BitFlagSet<8, PrivacyFlag>::Flag<2>; //!< Shared-WEP
    using Unknown_Wep = nn::util::BitFlagSet<8, PrivacyFlag>::Flag<3>; //!< Unknown-WEP
};

using PrivacyFlagSet = nn::util::BitFlagSet<8, PrivacyFlag>;


/**
 * @brief WPA/WPA2 の暗号方式を表します。
 */
struct CipherSuiteFlag
{
    using Group   = nn::util::BitFlagSet<8, CipherSuiteFlag>::Flag<0>; //!< UseGroupKey（非サポート）
    using Wep40   = nn::util::BitFlagSet<8, CipherSuiteFlag>::Flag<1>; //!< WEP40（非サポート）
    using Tkip    = nn::util::BitFlagSet<8, CipherSuiteFlag>::Flag<2>; //!< TKIP（非サポート）
    using AesOcB  = nn::util::BitFlagSet<8, CipherSuiteFlag>::Flag<3>; //!< AES-OCB（非サポート）
    using AesCcmp = nn::util::BitFlagSet<8, CipherSuiteFlag>::Flag<4>; //!< AES-CCMP
    using Wep104  = nn::util::BitFlagSet<8, CipherSuiteFlag>::Flag<5>; //!< WEP104（非サポート）
};

using CipherSuiteFlagSet = nn::util::BitFlagSet<8, CipherSuiteFlag>;

struct AkmSuiteFlag
{
    using Psk = nn::util::BitFlagSet<8, AkmSuiteFlag>::Flag<0>; // PSK
    using Eap = nn::util::BitFlagSet<8, AkmSuiteFlag>::Flag<1>; // 802.1X
    // FT over PSK
    // FT over 802.1X
};

using AkmSuiteFlagSet = nn::util::BitFlagSet<8, AkmSuiteFlag>;

struct WpaInfo
{
    CipherSuiteFlagSet groupDataCipherSuite;
    CipherSuiteFlagSet cipherSuites;
    AkmSuiteFlagSet akmSuites;
};

/**
 * @brief アクセスポイント情報をあらわす構造体です。
 */
struct AccessPointExtData
{
    Ssid ssid;                            //!< SSID
    MacAddress bssid;                     //!< BSSID
    int32_t rssi;                         //!< RSSI
    LinkLevel linkLevel;                  //!< 無線の信号強度レベル
    int16_t channel;                      //!< チャンネル
    PrivacyFlagSet privacy;
    WpaInfo wpa;
    WpaInfo wpa2;
    bool isSupported;
};

}
}
