﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

#include <nn/nifm/nifm_TypesLinkLevel.h>
#include <nn/nifm/nifm_TypesNetworkInterface.h>
#include <nn/nifm/nifm_TypesWirelessSetting.h>

namespace nn
{
namespace nifm
{

/**
 * @brief 一度に取得可能なアクセスポイントの最大数です。
 */
static const int32_t AccessPointCountMax = 32;

/**
 * @brief アクセスポイント情報をあらわす構造体です。
 */
struct AccessPointData
{
    Ssid ssid;                     //!< SSID
    MacAddress bssid;              //!< BSSID
    NN_PADDING1;
    int32_t rssi;                  //!< RSSI
    LinkLevel linkLevel;           //!< 無線の信号強度レベル
    int16_t channel;               //!< チャンネル
    NN_PADDING2;
    Authentication authentication; //!< 認証方式
    Encryption encryption;         //!< 暗号化方式
    Encryption groupEncryption;    //!< Group Cipher Suite
    bool isSupported;              //!< サポート対象フラグ
    NN_PADDING3;
};

}
}
