﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

namespace nn
{
namespace nifm
{

    //! @name システム状態関連 API
    //! @{

    /**
     * @brief   システムの健全性を確認します。
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     *   - その他の Result の場合、ネットワーク接続管理にかかわるシステムに問題が生じています。
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     * @details
     */
    nn::Result ConfirmSystemAvailability() NN_NOEXCEPT;

    //! @}

}
}
