﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

#include <nn/nifm/nifm_ApiScan.h>
#include <nn/nifm/nifm_TypesAccessPoint.h>
#include <nn/nifm/nifm_TypesRequirement.h>
#include <nn/nifm/nifm_TypesScan.h>

namespace nn
{
namespace nifm
{
    //! @name システム向けスキャン関連 API
    //! @{

    /**
     * @brief 明示的に周囲の無線環境をスキャンします。
     *
     * @param[in] preset スキャンに先立って提出する利用要求のプリセット
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *   - 異なるチャンネルを指定したスキャンの実行中ではない
     *
     * @details
     *  スキャンが完了するまでブロックします。
     *  使用可能なすべてのチャンネルに対してパッシブスキャンを行います。
     *
     *  内部で、指定されたプリセットを設定した利用要求を提出することでインターネット通信以外の利用要求を却下してからスキャンを行うため、
     *  必要に応じて利用者に確認ダイアログなどを表示してください。
     */
    nn::Result Scan(RequirementPreset preset) NN_NOEXCEPT;

    /**
     * @brief 明示的に指定されたチャンネルにおける周囲の無線環境をスキャンします。
     *
     * @param[in] scanChannels  スキャン対象となるチャンネルの配列
     * @param[in] count         ¥a scanChannels で指定されたチャンネルの個数
     * @param[in] preset        スキャンに先立って提出する利用要求のプリセット
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *   - 異なるチャンネルを指定したスキャンの実行中ではない
     *
     * @details
     *  スキャンが完了するまでブロックします。
     *  指定されたチャンネルに対してパッシブスキャンを行います。
     *
     *  内部で、指定されたプリセットを設定した利用要求を提出することでインターネット通信以外の利用要求を却下してからスキャンを行うため、
     *  必要に応じて利用者に確認ダイアログなどを表示してください。
     */
    nn::Result Scan(const int16_t scanChannels[], int count, RequirementPreset preset) NN_NOEXCEPT;

    //! @}
}
}
