﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/nifm_TypesNetworkInterface.h>

#include <nn/socket.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class SocketHolder
{
private:
    int m_Descriptor;
    nn::Bit64 m_ProcessId;

    bool m_IsCloseRequired;

public:
    // 与えられたソケットデスクリプタを格納してオブジェクトを生成します
    SocketHolder(int descriptor, nn::Bit64 processId) NN_NOEXCEPT;
    ~SocketHolder() NN_NOEXCEPT;

    // socketHolder で保持するソケットを複製してオブジェクトを生成します
    SocketHolder(const SocketHolder& socketHolder) NN_NOEXCEPT;

    // socketHolder で保持するソケットを移動してオブジェクトを生成します
    SocketHolder(SocketHolder&& socketHolder) NN_NOEXCEPT;

    Result GetDestination(nn::socket::SockAddrIn* pOutSockAddrIn) NN_NOEXCEPT;
    Result GetSource(nn::socket::SockAddrIn* pOutSockAddrIn) NN_NOEXCEPT;
    Result GetTcpInfo(nn::socket::TcpInfo* pOutTcpInfo) NN_NOEXCEPT;

    static nn::Result LookUpArpEntry(MacAddress* pOutMacAddress, nn::socket::InAddr inAddr) NN_NOEXCEPT;
};

}
}
}
