﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/os/os_SdkMutex.h>
#include <nn/nn_TimeSpan.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class FwdbgSettings
{
public:

private:
    mutable nn::os::SdkMutex m_Mutex;
    bool m_IsInitialized;

    int64_t m_ConnectionTestTimeout; // [ms]
    int64_t m_ApplyConfigTimeout; // [ms]
    int64_t m_EthernetAdapterStandbyTime; // [ms]

private:
    void Initialize() NN_NOEXCEPT;

public:
    FwdbgSettings() NN_NOEXCEPT;
    ~FwdbgSettings() NN_NOEXCEPT;

    TimeSpan GetConnectionTestTimeout() const NN_NOEXCEPT;
    TimeSpan GetApplyConfigTimeout() const NN_NOEXCEPT;
    TimeSpan GetEthernetAdapterStandbyTime() const NN_NOEXCEPT;

    static FwdbgSettings& GetSingleton() NN_NOEXCEPT;    // TODO: [TORIAEZU]
};

}
}
}
