﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>
#include <nn/nifm/detail/service/nifm_Capability.h>

#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class ServiceProvider;

class StaticServiceInterface
{
private:
    static uint32_t g_ClientIdCounter;

private:
    ServiceProvider* m_pServiceProvider;
    const Capability m_Capability;
    nn::sf::ExpHeapAllocator* m_pExpHeapAllocator;

public:
    explicit StaticServiceInterface(ServiceProvider* pServiceProvider, const Capability& capability, nn::sf::ExpHeapAllocator* pExpHeapAllocator) NN_NOEXCEPT;

    ~StaticServiceInterface() NN_NOEXCEPT;

    nn::Result CreateGeneralServiceOld(nn::sf::Out<nn::sf::SharedPointer<IGeneralService>> outIGeneralService) NN_NOEXCEPT;

    nn::Result CreateGeneralService(nn::sf::Out<nn::sf::SharedPointer<IGeneralService>> outIGeneralService, nn::Bit64 processId) NN_NOEXCEPT;

private:
    ClientId GenerateClientId() NN_NOEXCEPT;
};

}
}
}
