﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nifm/nifm_TypesClientManagement.h>
#include <nn/nifm/nifm_TypesIpSetting.h>
#include <nn/nifm/nifm_TypesNetworkInterface.h>
#include <nn/nifm/nifm_TypesNetworkProfile.h>
#include <nn/nifm/nifm_TypesRequestPrivate.h>
#include <nn/nifm/nifm_TypesRequirement.h>
#include <nn/nifm/nifm_TypesTelemetry.h>
#include <nn/nifm/nifm_TypesWirelessSetting.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/util/util_Uuid.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace nifm { namespace detail { // NOLINT(whitespace/braces)

class IGeneralService;

class INetworkProfile;

class IRequest;

class IScanRequest;

class IStaticService;

}}}

namespace nn { namespace nifm { namespace detail { namespace sf { // NOLINT(whitespace/braces)

struct AccessPointData;

struct AccessPointDataOld;

struct InternetConnectionStatus;

struct NetworkInterfaceInfo;

struct NetworkProfileBasicInfo;

struct NetworkProfileData;

struct AccessPointData
{
    nn::nifm::Ssid ssid;
    nn::nifm::MacAddress bssid;
    std::int32_t rssi;
    nn::Bit8 linkLevel;
    std::int16_t channel;
    nn::Bit8 authentication;
    nn::Bit8 encryption;
    nn::Bit8 groupEncryption;
    bool isSupported;
};

struct AccessPointDataOld
{
    nn::nifm::Ssid ssid;
    nn::nifm::MacAddress bssid;
    std::int32_t rssi;
    nn::Bit8 linkLevel;
    std::int16_t channel;
    nn::Bit8 authentication;
    nn::Bit8 encryption;
    nn::Bit8 groupEncryption;
};

struct InternetConnectionStatus
{
    nn::Bit8 networkInterfaceType;
    nn::Bit8 linkLevel;
    nn::Bit8 internetAvailability;
};

struct NetworkInterfaceInfo
{
    nn::Bit8 type;
    nn::nifm::MacAddress macAddress;
    bool isAvailable;
};

struct NetworkProfileBasicInfo
{
    nn::util::Uuid id;
    nn::Bit8 name[64];
    nn::Bit8 networkProfileType;
    nn::Bit8 networkInterfaceType;
    nn::nifm::Ssid ssid;
    nn::Bit8 authentication;
    nn::Bit8 encryption;
};

struct NetworkProfileData
{
    nn::nifm::IpSettingData ipSetting;
    nn::util::Uuid id;
    nn::Bit8 name[64];
    nn::Bit8 networkProfileType;
    nn::Bit8 networkInterfaceType;
    bool isAutoConnect;
    bool isLargeCapacity;
    nn::nifm::Ssid ssid;
    bool nonBroadcast;
    nn::Bit8 authentication;
    nn::Bit8 encryption;
    nn::nifm::SharedKey sharedKey;
};

}}}}

namespace nn { namespace nifm { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IGeneralService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IGeneralService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetClientId, (::nn::sf::Out<::nn::nifm::ClientId> outClientId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateScanRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IScanRequest>> outRequest))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IRequest>> outRequest, ::std::int32_t requirementPreset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentNetworkProfile, (::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateNetworkInterfaces, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkInterfaceInfo>& outNetworkInterfaceInfoArray, ::nn::sf::Out<int> outCount, ::nn::Bit32 filterFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateNetworkProfiles, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkProfileBasicInfo>& outNetworkProfileBasicInfoArray, ::nn::sf::Out<int> outCount, ::nn::Bit8 networkProfileType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkProfile, (::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData, const ::nn::util::Uuid& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkProfile, (::nn::sf::Out<::nn::util::Uuid> outId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RemoveNetworkProfile, (const ::nn::util::Uuid& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetScanDataOld, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointDataOld>& outAccessPointDataArray, ::nn::sf::Out<int> outCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentIpAddress, (::nn::sf::Out<::nn::nifm::IpV4Address> outIpAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentAccessPointOld, (::nn::sf::Out<::nn::nifm::detail::sf::AccessPointDataOld> outAccessPointData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateTemporaryNetworkProfile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::INetworkProfile>> outNetworkProfile, ::nn::sf::Out<::nn::util::Uuid> outNetworkProfileId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentIpConfigInfo, (::nn::sf::Out<::nn::nifm::IpAddressSetting> outIpAddressSetting, ::nn::sf::Out<::nn::nifm::DnsSetting> outDnsSetting))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessCommunicationEnabled, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsWirelessCommunicationEnabled, (::nn::sf::Out<bool> outIsEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInternetConnectionStatus, (::nn::sf::Out<::nn::nifm::detail::sf::InternetConnectionStatus> outConnectionStatus))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetEthernetCommunicationEnabled, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsEthernetCommunicationEnabled, (::nn::sf::Out<bool> outIsEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyInternetRequestAccepted, (::nn::sf::Out<bool> outIsAnyInternetRequestAccepted, ::nn::nifm::ClientId clientId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyForegroundRequestAccepted, (::nn::sf::Out<bool> outIsAnyForegroundRequestAccepted))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(PutToSleep)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(WakeUp)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSsidListVersion, (::nn::sf::Out<::nn::nifm::SsidListVersion> outSsidListVersion))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetExclusiveClient, (::nn::nifm::ClientId clientId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultIpSetting, (::nn::sf::Out<::nn::nifm::IpSettingData> outIpSettingData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultIpSetting, (const ::nn::nifm::IpSettingData& ipSettingData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessCommunicationEnabledForTest, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetEthernetCommunicationEnabledForTest, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTelemetorySystemEventReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTelemetryInfo, (::nn::sf::Out<::nn::nifm::TelemetryInfo> outTelemetryInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSystemAvailability)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetBackgroundRequestEnabled, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetScanData, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointData>& outAccessPointDataArray, ::nn::sf::Out<int> outCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentAccessPoint, (::nn::sf::Out<::nn::nifm::detail::sf::AccessPointData> outAccessPointData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Shutdown)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outChannelArray, ::nn::sf::Out<int> outCount))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IGeneralService)

        ::nn::Result GetClientId(::nn::sf::Out<::nn::nifm::ClientId> outClientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetClientId, (outClientId));
        }

        ::nn::Result CreateScanRequest(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IScanRequest>> outRequest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateScanRequest, (outRequest));
        }

        ::nn::Result CreateRequest(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IRequest>> outRequest, ::std::int32_t requirementPreset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateRequest, (outRequest, requirementPreset));
        }

        ::nn::Result GetCurrentNetworkProfile(::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentNetworkProfile, (outNetworkProfileData));
        }

        ::nn::Result EnumerateNetworkInterfaces(const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkInterfaceInfo>& outNetworkInterfaceInfoArray, ::nn::sf::Out<int> outCount, ::nn::Bit32 filterFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnumerateNetworkInterfaces, (outNetworkInterfaceInfoArray, outCount, filterFlags));
        }

        ::nn::Result EnumerateNetworkProfiles(const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkProfileBasicInfo>& outNetworkProfileBasicInfoArray, ::nn::sf::Out<int> outCount, ::nn::Bit8 networkProfileType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnumerateNetworkProfiles, (outNetworkProfileBasicInfoArray, outCount, networkProfileType));
        }

        ::nn::Result GetNetworkProfile(::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData, const ::nn::util::Uuid& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNetworkProfile, (outNetworkProfileData, id));
        }

        ::nn::Result SetNetworkProfile(::nn::sf::Out<::nn::util::Uuid> outId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNetworkProfile, (outId, networkProfileData));
        }

        ::nn::Result RemoveNetworkProfile(const ::nn::util::Uuid& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RemoveNetworkProfile, (id));
        }

        ::nn::Result GetScanDataOld(const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointDataOld>& outAccessPointDataArray, ::nn::sf::Out<int> outCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetScanDataOld, (outAccessPointDataArray, outCount));
        }

        ::nn::Result GetCurrentIpAddress(::nn::sf::Out<::nn::nifm::IpV4Address> outIpAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentIpAddress, (outIpAddress));
        }

        ::nn::Result GetCurrentAccessPointOld(::nn::sf::Out<::nn::nifm::detail::sf::AccessPointDataOld> outAccessPointData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentAccessPointOld, (outAccessPointData));
        }

        ::nn::Result CreateTemporaryNetworkProfile(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::INetworkProfile>> outNetworkProfile, ::nn::sf::Out<::nn::util::Uuid> outNetworkProfileId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateTemporaryNetworkProfile, (outNetworkProfile, outNetworkProfileId, networkProfileData));
        }

        ::nn::Result GetCurrentIpConfigInfo(::nn::sf::Out<::nn::nifm::IpAddressSetting> outIpAddressSetting, ::nn::sf::Out<::nn::nifm::DnsSetting> outDnsSetting) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentIpConfigInfo, (outIpAddressSetting, outDnsSetting));
        }

        ::nn::Result SetWirelessCommunicationEnabled(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetWirelessCommunicationEnabled, (isEnabled));
        }

        ::nn::Result IsWirelessCommunicationEnabled(::nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsWirelessCommunicationEnabled, (outIsEnabled));
        }

        ::nn::Result GetInternetConnectionStatus(::nn::sf::Out<::nn::nifm::detail::sf::InternetConnectionStatus> outConnectionStatus) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInternetConnectionStatus, (outConnectionStatus));
        }

        ::nn::Result SetEthernetCommunicationEnabled(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetEthernetCommunicationEnabled, (isEnabled));
        }

        ::nn::Result IsEthernetCommunicationEnabled(::nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsEthernetCommunicationEnabled, (outIsEnabled));
        }

        ::nn::Result IsAnyInternetRequestAccepted(::nn::sf::Out<bool> outIsAnyInternetRequestAccepted, ::nn::nifm::ClientId clientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAnyInternetRequestAccepted, (outIsAnyInternetRequestAccepted, clientId));
        }

        ::nn::Result IsAnyForegroundRequestAccepted(::nn::sf::Out<bool> outIsAnyForegroundRequestAccepted) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAnyForegroundRequestAccepted, (outIsAnyForegroundRequestAccepted));
        }

        ::nn::Result PutToSleep() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(PutToSleep);
        }

        ::nn::Result WakeUp() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(WakeUp);
        }

        ::nn::Result GetSsidListVersion(::nn::sf::Out<::nn::nifm::SsidListVersion> outSsidListVersion) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSsidListVersion, (outSsidListVersion));
        }

        ::nn::Result SetExclusiveClient(::nn::nifm::ClientId clientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetExclusiveClient, (clientId));
        }

        ::nn::Result GetDefaultIpSetting(::nn::sf::Out<::nn::nifm::IpSettingData> outIpSettingData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDefaultIpSetting, (outIpSettingData));
        }

        ::nn::Result SetDefaultIpSetting(const ::nn::nifm::IpSettingData& ipSettingData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDefaultIpSetting, (ipSettingData));
        }

        ::nn::Result SetWirelessCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetWirelessCommunicationEnabledForTest, (isEnabled));
        }

        ::nn::Result SetEthernetCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetEthernetCommunicationEnabledForTest, (isEnabled));
        }

        ::nn::Result GetTelemetorySystemEventReadableHandle(::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTelemetorySystemEventReadableHandle, (outSystemEventReadableHandle));
        }

        ::nn::Result GetTelemetryInfo(::nn::sf::Out<::nn::nifm::TelemetryInfo> outTelemetryInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTelemetryInfo, (outTelemetryInfo));
        }

        ::nn::Result ConfirmSystemAvailability() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ConfirmSystemAvailability);
        }

        ::nn::Result SetBackgroundRequestEnabled(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetBackgroundRequestEnabled, (isEnabled));
        }

        ::nn::Result GetScanData(const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointData>& outAccessPointDataArray, ::nn::sf::Out<int> outCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetScanData, (outAccessPointDataArray, outCount));
        }

        ::nn::Result GetCurrentAccessPoint(::nn::sf::Out<::nn::nifm::detail::sf::AccessPointData> outAccessPointData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentAccessPoint, (outAccessPointData));
        }

        ::nn::Result Shutdown() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Shutdown);
        }

        ::nn::Result GetAllowedChannels(const ::nn::sf::OutArray<::std::int16_t>& outChannelArray, ::nn::sf::Out<int> outCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAllowedChannels, (outChannelArray, outCount));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IGeneralService
    {
    public:
        nn::Result GetClientId(nn::sf::Out<nn::nifm::ClientId> outClientId) NN_NOEXCEPT;
        nn::Result CreateScanRequest(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IScanRequest>> outRequest) NN_NOEXCEPT;
        nn::Result CreateRequest(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IRequest>> outRequest, std::int32_t requirementPreset) NN_NOEXCEPT;
        nn::Result GetCurrentNetworkProfile(nn::sf::Out<nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData) NN_NOEXCEPT;
        nn::Result EnumerateNetworkInterfaces(const nn::sf::OutArray<nn::nifm::detail::sf::NetworkInterfaceInfo>& outNetworkInterfaceInfoArray, nn::sf::Out<int> outCount, nn::Bit32 filterFlags) NN_NOEXCEPT;
        nn::Result EnumerateNetworkProfiles(const nn::sf::OutArray<nn::nifm::detail::sf::NetworkProfileBasicInfo>& outNetworkProfileBasicInfoArray, nn::sf::Out<int> outCount, nn::Bit8 networkProfileType) NN_NOEXCEPT;
        nn::Result GetNetworkProfile(nn::sf::Out<nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData, const nn::util::Uuid& id) NN_NOEXCEPT;
        nn::Result SetNetworkProfile(nn::sf::Out<nn::util::Uuid> outId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT;
        nn::Result RemoveNetworkProfile(const nn::util::Uuid& id) NN_NOEXCEPT;
        nn::Result GetScanDataOld(const nn::sf::OutArray<nn::nifm::detail::sf::AccessPointDataOld>& outAccessPointDataArray, nn::sf::Out<int> outCount) NN_NOEXCEPT;
        nn::Result GetCurrentIpAddress(nn::sf::Out<nn::nifm::IpV4Address> outIpAddress) NN_NOEXCEPT;
        nn::Result GetCurrentAccessPointOld(nn::sf::Out<nn::nifm::detail::sf::AccessPointDataOld> outAccessPointData) NN_NOEXCEPT;
        nn::Result CreateTemporaryNetworkProfile(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::INetworkProfile>> outNetworkProfile, nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT;
        nn::Result GetCurrentIpConfigInfo(nn::sf::Out<nn::nifm::IpAddressSetting> outIpAddressSetting, nn::sf::Out<nn::nifm::DnsSetting> outDnsSetting) NN_NOEXCEPT;
        nn::Result SetWirelessCommunicationEnabled(bool isEnabled) NN_NOEXCEPT;
        nn::Result IsWirelessCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;
        nn::Result GetInternetConnectionStatus(nn::sf::Out<nn::nifm::detail::sf::InternetConnectionStatus> outConnectionStatus) NN_NOEXCEPT;
        nn::Result SetEthernetCommunicationEnabled(bool isEnabled) NN_NOEXCEPT;
        nn::Result IsEthernetCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;
        nn::Result IsAnyInternetRequestAccepted(nn::sf::Out<bool> outIsAnyInternetRequestAccepted, nn::nifm::ClientId clientId) NN_NOEXCEPT;
        nn::Result IsAnyForegroundRequestAccepted(nn::sf::Out<bool> outIsAnyForegroundRequestAccepted) NN_NOEXCEPT;
        nn::Result PutToSleep() NN_NOEXCEPT;
        nn::Result WakeUp() NN_NOEXCEPT;
        nn::Result GetSsidListVersion(nn::sf::Out<nn::nifm::SsidListVersion> outSsidListVersion) NN_NOEXCEPT;
        nn::Result SetExclusiveClient(nn::nifm::ClientId clientId) NN_NOEXCEPT;
        nn::Result GetDefaultIpSetting(nn::sf::Out<nn::nifm::IpSettingData> outIpSettingData) NN_NOEXCEPT;
        nn::Result SetDefaultIpSetting(const nn::nifm::IpSettingData& ipSettingData) NN_NOEXCEPT;
        nn::Result SetWirelessCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT;
        nn::Result SetEthernetCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT;
        nn::Result GetTelemetorySystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT;
        nn::Result GetTelemetryInfo(nn::sf::Out<nn::nifm::TelemetryInfo> outTelemetryInfo) NN_NOEXCEPT;
        nn::Result ConfirmSystemAvailability() NN_NOEXCEPT;
        nn::Result SetBackgroundRequestEnabled(bool isEnabled) NN_NOEXCEPT;
        nn::Result GetScanData(const nn::sf::OutArray<nn::nifm::detail::sf::AccessPointData>& outAccessPointDataArray, nn::sf::Out<int> outCount) NN_NOEXCEPT;
        nn::Result GetCurrentAccessPoint(nn::sf::Out<nn::nifm::detail::sf::AccessPointData> outAccessPointData) NN_NOEXCEPT;
        nn::Result Shutdown() NN_NOEXCEPT;
        nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outChannelArray, nn::sf::Out<int> outCount) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetClientId(nn::sf::Out<nn::nifm::ClientId> outClientId) NN_NOEXCEPT;
    nn::Result CreateScanRequest(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IScanRequest>> outRequest) NN_NOEXCEPT;
    nn::Result CreateRequest(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IRequest>> outRequest, std::int32_t requirementPreset) NN_NOEXCEPT;
    nn::Result GetCurrentNetworkProfile(nn::sf::Out<nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData) NN_NOEXCEPT;
    nn::Result EnumerateNetworkInterfaces(const nn::sf::OutArray<nn::nifm::detail::sf::NetworkInterfaceInfo>& outNetworkInterfaceInfoArray, nn::sf::Out<int> outCount, nn::Bit32 filterFlags) NN_NOEXCEPT;
    nn::Result EnumerateNetworkProfiles(const nn::sf::OutArray<nn::nifm::detail::sf::NetworkProfileBasicInfo>& outNetworkProfileBasicInfoArray, nn::sf::Out<int> outCount, nn::Bit8 networkProfileType) NN_NOEXCEPT;
    nn::Result GetNetworkProfile(nn::sf::Out<nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData, const nn::util::Uuid& id) NN_NOEXCEPT;
    nn::Result SetNetworkProfile(nn::sf::Out<nn::util::Uuid> outId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT;
    nn::Result RemoveNetworkProfile(const nn::util::Uuid& id) NN_NOEXCEPT;
    nn::Result GetScanDataOld(const nn::sf::OutArray<nn::nifm::detail::sf::AccessPointDataOld>& outAccessPointDataArray, nn::sf::Out<int> outCount) NN_NOEXCEPT;
    nn::Result GetCurrentIpAddress(nn::sf::Out<nn::nifm::IpV4Address> outIpAddress) NN_NOEXCEPT;
    nn::Result GetCurrentAccessPointOld(nn::sf::Out<nn::nifm::detail::sf::AccessPointDataOld> outAccessPointData) NN_NOEXCEPT;
    nn::Result CreateTemporaryNetworkProfile(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::INetworkProfile>> outNetworkProfile, nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT;
    nn::Result GetCurrentIpConfigInfo(nn::sf::Out<nn::nifm::IpAddressSetting> outIpAddressSetting, nn::sf::Out<nn::nifm::DnsSetting> outDnsSetting) NN_NOEXCEPT;
    nn::Result SetWirelessCommunicationEnabled(bool isEnabled) NN_NOEXCEPT;
    nn::Result IsWirelessCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;
    nn::Result GetInternetConnectionStatus(nn::sf::Out<nn::nifm::detail::sf::InternetConnectionStatus> outConnectionStatus) NN_NOEXCEPT;
    nn::Result SetEthernetCommunicationEnabled(bool isEnabled) NN_NOEXCEPT;
    nn::Result IsEthernetCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;
    nn::Result IsAnyInternetRequestAccepted(nn::sf::Out<bool> outIsAnyInternetRequestAccepted, nn::nifm::ClientId clientId) NN_NOEXCEPT;
    nn::Result IsAnyForegroundRequestAccepted(nn::sf::Out<bool> outIsAnyForegroundRequestAccepted) NN_NOEXCEPT;
    nn::Result PutToSleep() NN_NOEXCEPT;
    nn::Result WakeUp() NN_NOEXCEPT;
    nn::Result GetSsidListVersion(nn::sf::Out<nn::nifm::SsidListVersion> outSsidListVersion) NN_NOEXCEPT;
    nn::Result SetExclusiveClient(nn::nifm::ClientId clientId) NN_NOEXCEPT;
    nn::Result GetDefaultIpSetting(nn::sf::Out<nn::nifm::IpSettingData> outIpSettingData) NN_NOEXCEPT;
    nn::Result SetDefaultIpSetting(const nn::nifm::IpSettingData& ipSettingData) NN_NOEXCEPT;
    nn::Result SetWirelessCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT;
    nn::Result SetEthernetCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT;
    nn::Result GetTelemetorySystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT;
    nn::Result GetTelemetryInfo(nn::sf::Out<nn::nifm::TelemetryInfo> outTelemetryInfo) NN_NOEXCEPT;
    nn::Result ConfirmSystemAvailability() NN_NOEXCEPT;
    nn::Result SetBackgroundRequestEnabled(bool isEnabled) NN_NOEXCEPT;
    nn::Result GetScanData(const nn::sf::OutArray<nn::nifm::detail::sf::AccessPointData>& outAccessPointDataArray, nn::sf::Out<int> outCount) NN_NOEXCEPT;
    nn::Result GetCurrentAccessPoint(nn::sf::Out<nn::nifm::detail::sf::AccessPointData> outAccessPointData) NN_NOEXCEPT;
    nn::Result Shutdown() NN_NOEXCEPT;
    nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outChannelArray, nn::sf::Out<int> outCount) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nifm::detail::IGeneralService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClientId, (::nn::sf::Out<::nn::nifm::ClientId> outClientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetClientId, (outClientId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateScanRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IScanRequest>> outRequest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateScanRequest, (outRequest));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IRequest>> outRequest, ::std::int32_t requirementPreset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateRequest, (outRequest, requirementPreset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentNetworkProfile, (::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentNetworkProfile, (outNetworkProfileData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateNetworkInterfaces, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkInterfaceInfo>& outNetworkInterfaceInfoArray, ::nn::sf::Out<int> outCount, ::nn::Bit32 filterFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnumerateNetworkInterfaces, (outNetworkInterfaceInfoArray, outCount, filterFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateNetworkProfiles, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkProfileBasicInfo>& outNetworkProfileBasicInfoArray, ::nn::sf::Out<int> outCount, ::nn::Bit8 networkProfileType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnumerateNetworkProfiles, (outNetworkProfileBasicInfoArray, outCount, networkProfileType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkProfile, (::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData, const ::nn::util::Uuid& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNetworkProfile, (outNetworkProfileData, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkProfile, (::nn::sf::Out<::nn::util::Uuid> outId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNetworkProfile, (outId, networkProfileData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveNetworkProfile, (const ::nn::util::Uuid& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RemoveNetworkProfile, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanDataOld, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointDataOld>& outAccessPointDataArray, ::nn::sf::Out<int> outCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetScanDataOld, (outAccessPointDataArray, outCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentIpAddress, (::nn::sf::Out<::nn::nifm::IpV4Address> outIpAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentIpAddress, (outIpAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentAccessPointOld, (::nn::sf::Out<::nn::nifm::detail::sf::AccessPointDataOld> outAccessPointData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentAccessPointOld, (outAccessPointData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateTemporaryNetworkProfile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::INetworkProfile>> outNetworkProfile, ::nn::sf::Out<::nn::util::Uuid> outNetworkProfileId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateTemporaryNetworkProfile, (outNetworkProfile, outNetworkProfileId, networkProfileData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentIpConfigInfo, (::nn::sf::Out<::nn::nifm::IpAddressSetting> outIpAddressSetting, ::nn::sf::Out<::nn::nifm::DnsSetting> outDnsSetting))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentIpConfigInfo, (outIpAddressSetting, outDnsSetting));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessCommunicationEnabled, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetWirelessCommunicationEnabled, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsWirelessCommunicationEnabled, (::nn::sf::Out<bool> outIsEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsWirelessCommunicationEnabled, (outIsEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInternetConnectionStatus, (::nn::sf::Out<::nn::nifm::detail::sf::InternetConnectionStatus> outConnectionStatus))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInternetConnectionStatus, (outConnectionStatus));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetEthernetCommunicationEnabled, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetEthernetCommunicationEnabled, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsEthernetCommunicationEnabled, (::nn::sf::Out<bool> outIsEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsEthernetCommunicationEnabled, (outIsEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyInternetRequestAccepted, (::nn::sf::Out<bool> outIsAnyInternetRequestAccepted, ::nn::nifm::ClientId clientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAnyInternetRequestAccepted, (outIsAnyInternetRequestAccepted, clientId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyForegroundRequestAccepted, (::nn::sf::Out<bool> outIsAnyForegroundRequestAccepted))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAnyForegroundRequestAccepted, (outIsAnyForegroundRequestAccepted));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PutToSleep)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(PutToSleep);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(WakeUp)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(WakeUp);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSsidListVersion, (::nn::sf::Out<::nn::nifm::SsidListVersion> outSsidListVersion))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSsidListVersion, (outSsidListVersion));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetExclusiveClient, (::nn::nifm::ClientId clientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetExclusiveClient, (clientId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultIpSetting, (::nn::sf::Out<::nn::nifm::IpSettingData> outIpSettingData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDefaultIpSetting, (outIpSettingData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultIpSetting, (const ::nn::nifm::IpSettingData& ipSettingData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDefaultIpSetting, (ipSettingData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessCommunicationEnabledForTest, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetWirelessCommunicationEnabledForTest, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetEthernetCommunicationEnabledForTest, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetEthernetCommunicationEnabledForTest, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTelemetorySystemEventReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTelemetorySystemEventReadableHandle, (outSystemEventReadableHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTelemetryInfo, (::nn::sf::Out<::nn::nifm::TelemetryInfo> outTelemetryInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTelemetryInfo, (outTelemetryInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSystemAvailability)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ConfirmSystemAvailability);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBackgroundRequestEnabled, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetBackgroundRequestEnabled, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanData, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointData>& outAccessPointDataArray, ::nn::sf::Out<int> outCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetScanData, (outAccessPointDataArray, outCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentAccessPoint, (::nn::sf::Out<::nn::nifm::detail::sf::AccessPointData> outAccessPointData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentAccessPoint, (outAccessPointData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Shutdown)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Shutdown);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outChannelArray, ::nn::sf::Out<int> outCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAllowedChannels, (outChannelArray, outCount));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nifm::detail::IGeneralService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nifm::detail::IGeneralService))

    // nn::Result GetClientId(nn::sf::Out<nn::nifm::ClientId> outClientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetClientId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outClientId, 0, (::nn::sf::Out<::nn::nifm::ClientId>), 4, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outClientId))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outClientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetClientId)

    // nn::Result CreateScanRequest(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IScanRequest>> outRequest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateScanRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outRequest, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outRequest))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRequest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateScanRequest)

    // nn::Result CreateRequest(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IRequest>> outRequest, std::int32_t requirementPreset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outRequest, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outRequest))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requirementPreset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (requirementPreset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRequest), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requirementPreset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateRequest)

    // nn::Result GetCurrentNetworkProfile(nn::sf::Out<nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentNetworkProfile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outNetworkProfileData, 0, (::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData>), 380, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNetworkProfileData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNetworkProfileData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentNetworkProfile)

    // nn::Result EnumerateNetworkInterfaces(const nn::sf::OutArray<nn::nifm::detail::sf::NetworkInterfaceInfo>& outNetworkInterfaceInfoArray, nn::sf::Out<int> outCount, nn::Bit32 filterFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnumerateNetworkInterfaces)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outNetworkInterfaceInfoArray, 0, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkInterfaceInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNetworkInterfaceInfoArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filterFlags, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filterFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNetworkInterfaceInfoArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filterFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnumerateNetworkInterfaces)

    // nn::Result EnumerateNetworkProfiles(const nn::sf::OutArray<nn::nifm::detail::sf::NetworkProfileBasicInfo>& outNetworkProfileBasicInfoArray, nn::sf::Out<int> outCount, nn::Bit8 networkProfileType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnumerateNetworkProfiles)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outNetworkProfileBasicInfoArray, 0, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkProfileBasicInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNetworkProfileBasicInfoArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(networkProfileType, (::nn::Bit8), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (networkProfileType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNetworkProfileBasicInfoArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(networkProfileType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnumerateNetworkProfiles)

    // nn::Result GetNetworkProfile(nn::sf::Out<nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData, const nn::util::Uuid& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNetworkProfile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outNetworkProfileData, 0, (::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData>), 380, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outNetworkProfileData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNetworkProfileData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNetworkProfile)

    // nn::Result SetNetworkProfile(nn::sf::Out<nn::util::Uuid> outId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNetworkProfile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(networkProfileData, 0, (const ::nn::nifm::detail::sf::NetworkProfileData&), 380, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (networkProfileData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outId, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(networkProfileData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNetworkProfile)

    // nn::Result RemoveNetworkProfile(const nn::util::Uuid& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveNetworkProfile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveNetworkProfile)

    // nn::Result GetScanDataOld(const nn::sf::OutArray<nn::nifm::detail::sf::AccessPointDataOld>& outAccessPointDataArray, nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetScanDataOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAccessPointDataArray, 0, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointDataOld>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAccessPointDataArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAccessPointDataArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetScanDataOld)

    // nn::Result GetCurrentIpAddress(nn::sf::Out<nn::nifm::IpV4Address> outIpAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentIpAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIpAddress, (::nn::nifm::IpV4Address), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIpAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIpAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentIpAddress)

    // nn::Result GetCurrentAccessPointOld(nn::sf::Out<nn::nifm::detail::sf::AccessPointDataOld> outAccessPointData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentAccessPointOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outAccessPointData, 0, (::nn::sf::Out<::nn::nifm::detail::sf::AccessPointDataOld>), 52, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAccessPointData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAccessPointData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentAccessPointOld)

    // nn::Result CreateTemporaryNetworkProfile(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::INetworkProfile>> outNetworkProfile, nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateTemporaryNetworkProfile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(networkProfileData, 0, (const ::nn::nifm::detail::sf::NetworkProfileData&), 380, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (networkProfileData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outNetworkProfile, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outNetworkProfile))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNetworkProfileId, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNetworkProfileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNetworkProfile), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNetworkProfileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(networkProfileData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateTemporaryNetworkProfile)

    // nn::Result GetCurrentIpConfigInfo(nn::sf::Out<nn::nifm::IpAddressSetting> outIpAddressSetting, nn::sf::Out<nn::nifm::DnsSetting> outDnsSetting) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentIpConfigInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIpAddressSetting, (::nn::nifm::IpAddressSetting), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outDnsSetting, (::nn::nifm::DnsSetting), 13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outIpAddressSetting, outDnsSetting))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(22)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIpAddressSetting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDnsSetting)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentIpConfigInfo)

    // nn::Result SetWirelessCommunicationEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetWirelessCommunicationEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetWirelessCommunicationEnabled)

    // nn::Result IsWirelessCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsWirelessCommunicationEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsWirelessCommunicationEnabled)

    // nn::Result GetInternetConnectionStatus(nn::sf::Out<nn::nifm::detail::sf::InternetConnectionStatus> outConnectionStatus) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInternetConnectionStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outConnectionStatus, (::nn::nifm::detail::sf::InternetConnectionStatus), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outConnectionStatus))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outConnectionStatus)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInternetConnectionStatus)

    // nn::Result SetEthernetCommunicationEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetEthernetCommunicationEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetEthernetCommunicationEnabled)

    // nn::Result IsEthernetCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsEthernetCommunicationEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsEthernetCommunicationEnabled)

    // nn::Result IsAnyInternetRequestAccepted(nn::sf::Out<bool> outIsAnyInternetRequestAccepted, nn::nifm::ClientId clientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAnyInternetRequestAccepted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(clientId, 0, (::nn::nifm::ClientId), 4, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (clientId))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsAnyInternetRequestAccepted, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsAnyInternetRequestAccepted))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsAnyInternetRequestAccepted), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAnyInternetRequestAccepted)

    // nn::Result IsAnyForegroundRequestAccepted(nn::sf::Out<bool> outIsAnyForegroundRequestAccepted) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAnyForegroundRequestAccepted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsAnyForegroundRequestAccepted, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsAnyForegroundRequestAccepted))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsAnyForegroundRequestAccepted)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAnyForegroundRequestAccepted)

    // nn::Result PutToSleep() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PutToSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PutToSleep)

    // nn::Result WakeUp() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WakeUp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WakeUp)

    // nn::Result GetSsidListVersion(nn::sf::Out<nn::nifm::SsidListVersion> outSsidListVersion) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSsidListVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSsidListVersion, (::nn::nifm::SsidListVersion), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSsidListVersion))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSsidListVersion)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSsidListVersion)

    // nn::Result SetExclusiveClient(nn::nifm::ClientId clientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetExclusiveClient)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(clientId, 0, (::nn::nifm::ClientId), 4, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (clientId))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetExclusiveClient)

    // nn::Result GetDefaultIpSetting(nn::sf::Out<nn::nifm::IpSettingData> outIpSettingData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDefaultIpSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outIpSettingData, 0, (::nn::sf::Out<::nn::nifm::IpSettingData>), 194, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outIpSettingData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIpSettingData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDefaultIpSetting)

    // nn::Result SetDefaultIpSetting(const nn::nifm::IpSettingData& ipSettingData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDefaultIpSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(ipSettingData, 0, (const ::nn::nifm::IpSettingData&), 194, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (ipSettingData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipSettingData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDefaultIpSetting)

    // nn::Result SetWirelessCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetWirelessCommunicationEnabledForTest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetWirelessCommunicationEnabledForTest)

    // nn::Result SetEthernetCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetEthernetCommunicationEnabledForTest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetEthernetCommunicationEnabledForTest)

    // nn::Result GetTelemetorySystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTelemetorySystemEventReadableHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outSystemEventReadableHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outSystemEventReadableHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSystemEventReadableHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTelemetorySystemEventReadableHandle)

    // nn::Result GetTelemetryInfo(nn::sf::Out<nn::nifm::TelemetryInfo> outTelemetryInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTelemetryInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outTelemetryInfo, 0, (::nn::sf::Out<::nn::nifm::TelemetryInfo>), 1568, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outTelemetryInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTelemetryInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTelemetryInfo)

    // nn::Result ConfirmSystemAvailability() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConfirmSystemAvailability)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConfirmSystemAvailability)

    // nn::Result SetBackgroundRequestEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetBackgroundRequestEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetBackgroundRequestEnabled)

    // nn::Result GetScanData(const nn::sf::OutArray<nn::nifm::detail::sf::AccessPointData>& outAccessPointDataArray, nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetScanData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAccessPointDataArray, 0, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointData>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAccessPointDataArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAccessPointDataArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetScanData)

    // nn::Result GetCurrentAccessPoint(nn::sf::Out<nn::nifm::detail::sf::AccessPointData> outAccessPointData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentAccessPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outAccessPointData, 0, (::nn::sf::Out<::nn::nifm::detail::sf::AccessPointData>), 52, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAccessPointData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAccessPointData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentAccessPoint)

    // nn::Result Shutdown() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Shutdown)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Shutdown)

    // nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outChannelArray, nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAllowedChannels)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(38)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outChannelArray, 0, (const ::nn::sf::OutArray<::std::int16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outChannelArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outChannelArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAllowedChannels)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::ClientId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::detail::sf::NetworkProfileData), 380, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::detail::sf::NetworkInterfaceInfo), 8, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::detail::sf::NetworkProfileBasicInfo), 117, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::util::Uuid), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::detail::sf::AccessPointDataOld), 52, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::IpV4Address), 4, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::IpAddressSetting), 13, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::DnsSetting), 9, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::detail::sf::InternetConnectionStatus), 3, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::SsidListVersion), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::IpSettingData), 194, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::TelemetryInfo), 1568, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::detail::sf::AccessPointData), 52, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nifm::detail::IGeneralService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nifm::detail::IGeneralService))

    // nn::Result GetClientId(nn::sf::Out<nn::nifm::ClientId> outClientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClientId, (::nn::sf::Out<::nn::nifm::ClientId> outClientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetClientId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outClientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetClientId)
    }

    // nn::Result CreateScanRequest(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IScanRequest>> outRequest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateScanRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IScanRequest>> outRequest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateScanRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateScanRequest)
    }

    // nn::Result CreateRequest(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IRequest>> outRequest, std::int32_t requirementPreset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IRequest>> outRequest, ::std::int32_t requirementPreset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requirementPreset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateRequest)
    }

    // nn::Result GetCurrentNetworkProfile(nn::sf::Out<nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentNetworkProfile, (::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentNetworkProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNetworkProfileData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentNetworkProfile)
    }

    // nn::Result EnumerateNetworkInterfaces(const nn::sf::OutArray<nn::nifm::detail::sf::NetworkInterfaceInfo>& outNetworkInterfaceInfoArray, nn::sf::Out<int> outCount, nn::Bit32 filterFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateNetworkInterfaces, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkInterfaceInfo>& outNetworkInterfaceInfoArray, ::nn::sf::Out<int> outCount, ::nn::Bit32 filterFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnumerateNetworkInterfaces)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNetworkInterfaceInfoArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filterFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnumerateNetworkInterfaces)
    }

    // nn::Result EnumerateNetworkProfiles(const nn::sf::OutArray<nn::nifm::detail::sf::NetworkProfileBasicInfo>& outNetworkProfileBasicInfoArray, nn::sf::Out<int> outCount, nn::Bit8 networkProfileType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateNetworkProfiles, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::NetworkProfileBasicInfo>& outNetworkProfileBasicInfoArray, ::nn::sf::Out<int> outCount, ::nn::Bit8 networkProfileType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnumerateNetworkProfiles)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNetworkProfileBasicInfoArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(networkProfileType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnumerateNetworkProfiles)
    }

    // nn::Result GetNetworkProfile(nn::sf::Out<nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData, const nn::util::Uuid& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkProfile, (::nn::sf::Out<::nn::nifm::detail::sf::NetworkProfileData> outNetworkProfileData, const ::nn::util::Uuid& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNetworkProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNetworkProfileData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNetworkProfile)
    }

    // nn::Result SetNetworkProfile(nn::sf::Out<nn::util::Uuid> outId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkProfile, (::nn::sf::Out<::nn::util::Uuid> outId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNetworkProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(networkProfileData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNetworkProfile)
    }

    // nn::Result RemoveNetworkProfile(const nn::util::Uuid& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveNetworkProfile, (const ::nn::util::Uuid& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveNetworkProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveNetworkProfile)
    }

    // nn::Result GetScanDataOld(const nn::sf::OutArray<nn::nifm::detail::sf::AccessPointDataOld>& outAccessPointDataArray, nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanDataOld, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointDataOld>& outAccessPointDataArray, ::nn::sf::Out<int> outCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetScanDataOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAccessPointDataArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetScanDataOld)
    }

    // nn::Result GetCurrentIpAddress(nn::sf::Out<nn::nifm::IpV4Address> outIpAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentIpAddress, (::nn::sf::Out<::nn::nifm::IpV4Address> outIpAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentIpAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIpAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentIpAddress)
    }

    // nn::Result GetCurrentAccessPointOld(nn::sf::Out<nn::nifm::detail::sf::AccessPointDataOld> outAccessPointData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentAccessPointOld, (::nn::sf::Out<::nn::nifm::detail::sf::AccessPointDataOld> outAccessPointData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentAccessPointOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAccessPointData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentAccessPointOld)
    }

    // nn::Result CreateTemporaryNetworkProfile(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::INetworkProfile>> outNetworkProfile, nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateTemporaryNetworkProfile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::INetworkProfile>> outNetworkProfile, ::nn::sf::Out<::nn::util::Uuid> outNetworkProfileId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateTemporaryNetworkProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNetworkProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNetworkProfileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(networkProfileData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateTemporaryNetworkProfile)
    }

    // nn::Result GetCurrentIpConfigInfo(nn::sf::Out<nn::nifm::IpAddressSetting> outIpAddressSetting, nn::sf::Out<nn::nifm::DnsSetting> outDnsSetting) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentIpConfigInfo, (::nn::sf::Out<::nn::nifm::IpAddressSetting> outIpAddressSetting, ::nn::sf::Out<::nn::nifm::DnsSetting> outDnsSetting))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentIpConfigInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIpAddressSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDnsSetting)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentIpConfigInfo)
    }

    // nn::Result SetWirelessCommunicationEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessCommunicationEnabled, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetWirelessCommunicationEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetWirelessCommunicationEnabled)
    }

    // nn::Result IsWirelessCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsWirelessCommunicationEnabled, (::nn::sf::Out<bool> outIsEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsWirelessCommunicationEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsWirelessCommunicationEnabled)
    }

    // nn::Result GetInternetConnectionStatus(nn::sf::Out<nn::nifm::detail::sf::InternetConnectionStatus> outConnectionStatus) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInternetConnectionStatus, (::nn::sf::Out<::nn::nifm::detail::sf::InternetConnectionStatus> outConnectionStatus))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInternetConnectionStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outConnectionStatus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInternetConnectionStatus)
    }

    // nn::Result SetEthernetCommunicationEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetEthernetCommunicationEnabled, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetEthernetCommunicationEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetEthernetCommunicationEnabled)
    }

    // nn::Result IsEthernetCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsEthernetCommunicationEnabled, (::nn::sf::Out<bool> outIsEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsEthernetCommunicationEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsEthernetCommunicationEnabled)
    }

    // nn::Result IsAnyInternetRequestAccepted(nn::sf::Out<bool> outIsAnyInternetRequestAccepted, nn::nifm::ClientId clientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyInternetRequestAccepted, (::nn::sf::Out<bool> outIsAnyInternetRequestAccepted, ::nn::nifm::ClientId clientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAnyInternetRequestAccepted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsAnyInternetRequestAccepted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAnyInternetRequestAccepted)
    }

    // nn::Result IsAnyForegroundRequestAccepted(nn::sf::Out<bool> outIsAnyForegroundRequestAccepted) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyForegroundRequestAccepted, (::nn::sf::Out<bool> outIsAnyForegroundRequestAccepted))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAnyForegroundRequestAccepted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsAnyForegroundRequestAccepted)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAnyForegroundRequestAccepted)
    }

    // nn::Result PutToSleep() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PutToSleep)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PutToSleep)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PutToSleep)
    }

    // nn::Result WakeUp() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(WakeUp)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WakeUp)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WakeUp)
    }

    // nn::Result GetSsidListVersion(nn::sf::Out<nn::nifm::SsidListVersion> outSsidListVersion) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSsidListVersion, (::nn::sf::Out<::nn::nifm::SsidListVersion> outSsidListVersion))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSsidListVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSsidListVersion)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSsidListVersion)
    }

    // nn::Result SetExclusiveClient(nn::nifm::ClientId clientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetExclusiveClient, (::nn::nifm::ClientId clientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetExclusiveClient)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetExclusiveClient)
    }

    // nn::Result GetDefaultIpSetting(nn::sf::Out<nn::nifm::IpSettingData> outIpSettingData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultIpSetting, (::nn::sf::Out<::nn::nifm::IpSettingData> outIpSettingData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDefaultIpSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIpSettingData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDefaultIpSetting)
    }

    // nn::Result SetDefaultIpSetting(const nn::nifm::IpSettingData& ipSettingData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDefaultIpSetting, (const ::nn::nifm::IpSettingData& ipSettingData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDefaultIpSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipSettingData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDefaultIpSetting)
    }

    // nn::Result SetWirelessCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessCommunicationEnabledForTest, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetWirelessCommunicationEnabledForTest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetWirelessCommunicationEnabledForTest)
    }

    // nn::Result SetEthernetCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetEthernetCommunicationEnabledForTest, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetEthernetCommunicationEnabledForTest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetEthernetCommunicationEnabledForTest)
    }

    // nn::Result GetTelemetorySystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTelemetorySystemEventReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTelemetorySystemEventReadableHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSystemEventReadableHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTelemetorySystemEventReadableHandle)
    }

    // nn::Result GetTelemetryInfo(nn::sf::Out<nn::nifm::TelemetryInfo> outTelemetryInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTelemetryInfo, (::nn::sf::Out<::nn::nifm::TelemetryInfo> outTelemetryInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTelemetryInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTelemetryInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTelemetryInfo)
    }

    // nn::Result ConfirmSystemAvailability() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConfirmSystemAvailability)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConfirmSystemAvailability)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConfirmSystemAvailability)
    }

    // nn::Result SetBackgroundRequestEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBackgroundRequestEnabled, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetBackgroundRequestEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetBackgroundRequestEnabled)
    }

    // nn::Result GetScanData(const nn::sf::OutArray<nn::nifm::detail::sf::AccessPointData>& outAccessPointDataArray, nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanData, (const ::nn::sf::OutArray<::nn::nifm::detail::sf::AccessPointData>& outAccessPointDataArray, ::nn::sf::Out<int> outCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetScanData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAccessPointDataArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetScanData)
    }

    // nn::Result GetCurrentAccessPoint(nn::sf::Out<nn::nifm::detail::sf::AccessPointData> outAccessPointData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentAccessPoint, (::nn::sf::Out<::nn::nifm::detail::sf::AccessPointData> outAccessPointData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentAccessPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAccessPointData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentAccessPoint)
    }

    // nn::Result Shutdown() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Shutdown)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Shutdown)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Shutdown)
    }

    // nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outChannelArray, nn::sf::Out<int> outCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outChannelArray, ::nn::sf::Out<int> outCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAllowedChannels)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outChannelArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAllowedChannels)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nifm::detail::IGeneralService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nifm::detail::IGeneralService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetClientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outClientId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetClientId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outClientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateScanRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nifm::detail::IScanRequest>), outRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateScanRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outRequest, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nifm::detail::IRequest>), outRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outRequest),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requirementPreset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outRequest, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNetworkProfileData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentNetworkProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNetworkProfileData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnumerateNetworkInterfaces)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNetworkInterfaceInfoArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnumerateNetworkInterfaces)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNetworkInterfaceInfoArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filterFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnumerateNetworkProfiles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNetworkProfileBasicInfoArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnumerateNetworkProfiles)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNetworkProfileBasicInfoArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(networkProfileType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outNetworkProfileData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNetworkProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outNetworkProfileData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(networkProfileData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNetworkProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(networkProfileData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveNetworkProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetScanDataOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAccessPointDataArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetScanDataOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAccessPointDataArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentIpAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentIpAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIpAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentAccessPointOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAccessPointData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentAccessPointOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAccessPointData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateTemporaryNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(networkProfileData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nifm::detail::INetworkProfile>), outNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateTemporaryNetworkProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outNetworkProfile),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNetworkProfileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(networkProfileData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outNetworkProfile, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentIpConfigInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentIpConfigInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIpAddressSetting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outDnsSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetWirelessCommunicationEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetWirelessCommunicationEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsWirelessCommunicationEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsWirelessCommunicationEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInternetConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInternetConnectionStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetEthernetCommunicationEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetEthernetCommunicationEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsEthernetCommunicationEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsEthernetCommunicationEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAnyInternetRequestAccepted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(clientId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAnyInternetRequestAccepted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsAnyInternetRequestAccepted),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(clientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAnyForegroundRequestAccepted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAnyForegroundRequestAccepted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsAnyForegroundRequestAccepted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PutToSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PutToSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSsidListVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSsidListVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSsidListVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetExclusiveClient)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(clientId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetExclusiveClient)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(clientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDefaultIpSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outIpSettingData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDefaultIpSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outIpSettingData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDefaultIpSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ipSettingData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDefaultIpSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ipSettingData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetWirelessCommunicationEnabledForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetWirelessCommunicationEnabledForTest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetEthernetCommunicationEnabledForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetEthernetCommunicationEnabledForTest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTelemetorySystemEventReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outSystemEventReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTelemetorySystemEventReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outSystemEventReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTelemetryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outTelemetryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTelemetryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outTelemetryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConfirmSystemAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConfirmSystemAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetBackgroundRequestEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetBackgroundRequestEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetScanData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAccessPointDataArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetScanData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAccessPointDataArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentAccessPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAccessPointData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentAccessPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAccessPointData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAllowedChannels)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outChannelArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAllowedChannels)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outChannelArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetClientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateScanRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnumerateNetworkInterfaces)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnumerateNetworkProfiles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetScanDataOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentIpAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentAccessPointOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateTemporaryNetworkProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentIpConfigInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetWirelessCommunicationEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsWirelessCommunicationEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInternetConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetEthernetCommunicationEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsEthernetCommunicationEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAnyInternetRequestAccepted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAnyForegroundRequestAccepted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PutToSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSsidListVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetExclusiveClient)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDefaultIpSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDefaultIpSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetWirelessCommunicationEnabledForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetEthernetCommunicationEnabledForTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTelemetorySystemEventReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTelemetryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConfirmSystemAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetBackgroundRequestEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetScanData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentAccessPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAllowedChannels)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nifm::detail::IGeneralService))

namespace nn { namespace nifm { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(INetworkProfile, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(INetworkProfile)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Update, (::nn::sf::Out<::nn::util::Uuid> outNetworkProfileId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PersistOld, (::nn::sf::Out<::nn::util::Uuid> outId, const ::nn::util::Uuid& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Persist, (::nn::sf::Out<::nn::util::Uuid> outId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(INetworkProfile)

        ::nn::Result Update(::nn::sf::Out<::nn::util::Uuid> outNetworkProfileId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Update, (outNetworkProfileId, networkProfileData));
        }

        ::nn::Result PersistOld(::nn::sf::Out<::nn::util::Uuid> outId, const ::nn::util::Uuid& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PersistOld, (outId, id));
        }

        ::nn::Result Persist(::nn::sf::Out<::nn::util::Uuid> outId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Persist, (outId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class INetworkProfile
    {
    public:
        nn::Result Update(nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT;
        nn::Result PersistOld(nn::sf::Out<nn::util::Uuid> outId, const nn::util::Uuid& id) NN_NOEXCEPT;
        nn::Result Persist(nn::sf::Out<nn::util::Uuid> outId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Update(nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT;
    nn::Result PersistOld(nn::sf::Out<nn::util::Uuid> outId, const nn::util::Uuid& id) NN_NOEXCEPT;
    nn::Result Persist(nn::sf::Out<nn::util::Uuid> outId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nifm::detail::INetworkProfile))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Update, (::nn::sf::Out<::nn::util::Uuid> outNetworkProfileId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Update, (outNetworkProfileId, networkProfileData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PersistOld, (::nn::sf::Out<::nn::util::Uuid> outId, const ::nn::util::Uuid& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PersistOld, (outId, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Persist, (::nn::sf::Out<::nn::util::Uuid> outId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Persist, (outId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nifm::detail::INetworkProfile>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nifm::detail::INetworkProfile))

    // nn::Result Update(nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Update)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(networkProfileData, 0, (const ::nn::nifm::detail::sf::NetworkProfileData&), 380, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (networkProfileData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outNetworkProfileId, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outNetworkProfileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outNetworkProfileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(networkProfileData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Update)

    // nn::Result PersistOld(nn::sf::Out<nn::util::Uuid> outId, const nn::util::Uuid& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PersistOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outId, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PersistOld)

    // nn::Result Persist(nn::sf::Out<nn::util::Uuid> outId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Persist)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outId, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Persist)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::util::Uuid), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::detail::sf::NetworkProfileData), 380, 2)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nifm::detail::INetworkProfile, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nifm::detail::INetworkProfile))

    // nn::Result Update(nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const nn::nifm::detail::sf::NetworkProfileData& networkProfileData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Update, (::nn::sf::Out<::nn::util::Uuid> outNetworkProfileId, const ::nn::nifm::detail::sf::NetworkProfileData& networkProfileData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Update)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outNetworkProfileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(networkProfileData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Update)
    }

    // nn::Result PersistOld(nn::sf::Out<nn::util::Uuid> outId, const nn::util::Uuid& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PersistOld, (::nn::sf::Out<::nn::util::Uuid> outId, const ::nn::util::Uuid& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PersistOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PersistOld)
    }

    // nn::Result Persist(nn::sf::Out<nn::util::Uuid> outId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Persist, (::nn::sf::Out<::nn::util::Uuid> outId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Persist)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Persist)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nifm::detail::INetworkProfile>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nifm::detail::INetworkProfile))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Update)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(networkProfileData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Update)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outNetworkProfileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(networkProfileData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PersistOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PersistOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Persist)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Persist)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Update)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PersistOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Persist)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nifm::detail::INetworkProfile))

namespace nn { namespace nifm { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IRequest, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IRequest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestState, (::nn::sf::Out<::std::int32_t> outRequestState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEventReadableHandles, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle1, ::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle2))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Submit)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirement, (const ::nn::nifm::Requirement& requirement))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirementPreset, (::std::int32_t requirementPreset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPriority, (::std::uint8_t priority))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkProfileId, (const ::nn::util::Uuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRejectable, (bool isRejectable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetConnectionConfirmationOption, (::std::int8_t connectionConfirmationOption))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPersistent, (bool isPersistent))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInstant, (bool isInstant))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSustainable, (bool isSustainable, ::std::uint8_t priority))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRawPriority, (::std::uint8_t rawPriority))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetGreedy, (bool isGreedy))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSharable, (bool isSharable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirementByRevision, (::std::uint32_t revision))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequirement, (::nn::sf::Out<::nn::nifm::Requirement> outRequirement))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRevision, (::nn::sf::Out<::std::uint32_t> outRevision))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAppletInfo, (::nn::sf::Out<::nn::Bit32> outAppletId, ::nn::sf::Out<::nn::Bit32> outLibraryAppletmode, ::nn::sf::Out<::std::uint32_t> outSize, const ::nn::sf::OutBuffer& outBuffer, ::std::uint32_t colorIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAdditionalInfo, (::nn::sf::Out<::nn::nifm::AdditionalInfo> outAdditionalInfo, ::nn::sf::Out<::std::uint32_t> outRevision))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetKeptInSleep, (bool isKeptInSleep))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSocketDescriptor, (::std::int32_t socketDescriptor))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterSocketDescriptor, (::std::int32_t socketDescriptor))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IRequest)

        ::nn::Result GetRequestState(::nn::sf::Out<::std::int32_t> outRequestState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequestState, (outRequestState));
        }

        ::nn::Result GetResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetResult);
        }

        ::nn::Result GetSystemEventReadableHandles(::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle1, ::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle2) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemEventReadableHandles, (outSystemEventReadableHandle1, outSystemEventReadableHandle2));
        }

        ::nn::Result Cancel() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Cancel);
        }

        ::nn::Result Submit() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Submit);
        }

        ::nn::Result SetRequirement(const ::nn::nifm::Requirement& requirement) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRequirement, (requirement));
        }

        ::nn::Result SetRequirementPreset(::std::int32_t requirementPreset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRequirementPreset, (requirementPreset));
        }

        ::nn::Result SetPriority(::std::uint8_t priority) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPriority, (priority));
        }

        ::nn::Result SetNetworkProfileId(const ::nn::util::Uuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNetworkProfileId, (uuid));
        }

        ::nn::Result SetRejectable(bool isRejectable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRejectable, (isRejectable));
        }

        ::nn::Result SetConnectionConfirmationOption(::std::int8_t connectionConfirmationOption) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetConnectionConfirmationOption, (connectionConfirmationOption));
        }

        ::nn::Result SetPersistent(bool isPersistent) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPersistent, (isPersistent));
        }

        ::nn::Result SetInstant(bool isInstant) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInstant, (isInstant));
        }

        ::nn::Result SetSustainable(bool isSustainable, ::std::uint8_t priority) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSustainable, (isSustainable, priority));
        }

        ::nn::Result SetRawPriority(::std::uint8_t rawPriority) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRawPriority, (rawPriority));
        }

        ::nn::Result SetGreedy(bool isGreedy) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetGreedy, (isGreedy));
        }

        ::nn::Result SetSharable(bool isSharable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSharable, (isSharable));
        }

        ::nn::Result SetRequirementByRevision(::std::uint32_t revision) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetRequirementByRevision, (revision));
        }

        ::nn::Result GetRequirement(::nn::sf::Out<::nn::nifm::Requirement> outRequirement) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequirement, (outRequirement));
        }

        ::nn::Result GetRevision(::nn::sf::Out<::std::uint32_t> outRevision) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRevision, (outRevision));
        }

        ::nn::Result GetAppletInfo(::nn::sf::Out<::nn::Bit32> outAppletId, ::nn::sf::Out<::nn::Bit32> outLibraryAppletmode, ::nn::sf::Out<::std::uint32_t> outSize, const ::nn::sf::OutBuffer& outBuffer, ::std::uint32_t colorIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAppletInfo, (outAppletId, outLibraryAppletmode, outSize, outBuffer, colorIndex));
        }

        ::nn::Result GetAdditionalInfo(::nn::sf::Out<::nn::nifm::AdditionalInfo> outAdditionalInfo, ::nn::sf::Out<::std::uint32_t> outRevision) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAdditionalInfo, (outAdditionalInfo, outRevision));
        }

        ::nn::Result SetKeptInSleep(bool isKeptInSleep) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetKeptInSleep, (isKeptInSleep));
        }

        ::nn::Result RegisterSocketDescriptor(::std::int32_t socketDescriptor) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterSocketDescriptor, (socketDescriptor));
        }

        ::nn::Result UnregisterSocketDescriptor(::std::int32_t socketDescriptor) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterSocketDescriptor, (socketDescriptor));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IRequest
    {
    public:
        nn::Result GetRequestState(nn::sf::Out<std::int32_t> outRequestState) NN_NOEXCEPT;
        nn::Result GetResult() NN_NOEXCEPT;
        nn::Result GetSystemEventReadableHandles(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle1, nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle2) NN_NOEXCEPT;
        nn::Result Cancel() NN_NOEXCEPT;
        nn::Result Submit() NN_NOEXCEPT;
        nn::Result SetRequirement(const nn::nifm::Requirement& requirement) NN_NOEXCEPT;
        nn::Result SetRequirementPreset(std::int32_t requirementPreset) NN_NOEXCEPT;
        nn::Result SetPriority(std::uint8_t priority) NN_NOEXCEPT;
        nn::Result SetNetworkProfileId(const nn::util::Uuid& uuid) NN_NOEXCEPT;
        nn::Result SetRejectable(bool isRejectable) NN_NOEXCEPT;
        nn::Result SetConnectionConfirmationOption(std::int8_t connectionConfirmationOption) NN_NOEXCEPT;
        nn::Result SetPersistent(bool isPersistent) NN_NOEXCEPT;
        nn::Result SetInstant(bool isInstant) NN_NOEXCEPT;
        nn::Result SetSustainable(bool isSustainable, std::uint8_t priority) NN_NOEXCEPT;
        nn::Result SetRawPriority(std::uint8_t rawPriority) NN_NOEXCEPT;
        nn::Result SetGreedy(bool isGreedy) NN_NOEXCEPT;
        nn::Result SetSharable(bool isSharable) NN_NOEXCEPT;
        nn::Result SetRequirementByRevision(std::uint32_t revision) NN_NOEXCEPT;
        nn::Result GetRequirement(nn::sf::Out<nn::nifm::Requirement> outRequirement) NN_NOEXCEPT;
        nn::Result GetRevision(nn::sf::Out<std::uint32_t> outRevision) NN_NOEXCEPT;
        nn::Result GetAppletInfo(nn::sf::Out<nn::Bit32> outAppletId, nn::sf::Out<nn::Bit32> outLibraryAppletmode, nn::sf::Out<std::uint32_t> outSize, const nn::sf::OutBuffer& outBuffer, std::uint32_t colorIndex) NN_NOEXCEPT;
        nn::Result GetAdditionalInfo(nn::sf::Out<nn::nifm::AdditionalInfo> outAdditionalInfo, nn::sf::Out<std::uint32_t> outRevision) NN_NOEXCEPT;
        nn::Result SetKeptInSleep(bool isKeptInSleep) NN_NOEXCEPT;
        nn::Result RegisterSocketDescriptor(std::int32_t socketDescriptor) NN_NOEXCEPT;
        nn::Result UnregisterSocketDescriptor(std::int32_t socketDescriptor) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetRequestState(nn::sf::Out<std::int32_t> outRequestState) NN_NOEXCEPT;
    nn::Result GetResult() NN_NOEXCEPT;
    nn::Result GetSystemEventReadableHandles(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle1, nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle2) NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result Submit() NN_NOEXCEPT;
    nn::Result SetRequirement(const nn::nifm::Requirement& requirement) NN_NOEXCEPT;
    nn::Result SetRequirementPreset(std::int32_t requirementPreset) NN_NOEXCEPT;
    nn::Result SetPriority(std::uint8_t priority) NN_NOEXCEPT;
    nn::Result SetNetworkProfileId(const nn::util::Uuid& uuid) NN_NOEXCEPT;
    nn::Result SetRejectable(bool isRejectable) NN_NOEXCEPT;
    nn::Result SetConnectionConfirmationOption(std::int8_t connectionConfirmationOption) NN_NOEXCEPT;
    nn::Result SetPersistent(bool isPersistent) NN_NOEXCEPT;
    nn::Result SetInstant(bool isInstant) NN_NOEXCEPT;
    nn::Result SetSustainable(bool isSustainable, std::uint8_t priority) NN_NOEXCEPT;
    nn::Result SetRawPriority(std::uint8_t rawPriority) NN_NOEXCEPT;
    nn::Result SetGreedy(bool isGreedy) NN_NOEXCEPT;
    nn::Result SetSharable(bool isSharable) NN_NOEXCEPT;
    nn::Result SetRequirementByRevision(std::uint32_t revision) NN_NOEXCEPT;
    nn::Result GetRequirement(nn::sf::Out<nn::nifm::Requirement> outRequirement) NN_NOEXCEPT;
    nn::Result GetRevision(nn::sf::Out<std::uint32_t> outRevision) NN_NOEXCEPT;
    nn::Result GetAppletInfo(nn::sf::Out<nn::Bit32> outAppletId, nn::sf::Out<nn::Bit32> outLibraryAppletmode, nn::sf::Out<std::uint32_t> outSize, const nn::sf::OutBuffer& outBuffer, std::uint32_t colorIndex) NN_NOEXCEPT;
    nn::Result GetAdditionalInfo(nn::sf::Out<nn::nifm::AdditionalInfo> outAdditionalInfo, nn::sf::Out<std::uint32_t> outRevision) NN_NOEXCEPT;
    nn::Result SetKeptInSleep(bool isKeptInSleep) NN_NOEXCEPT;
    nn::Result RegisterSocketDescriptor(std::int32_t socketDescriptor) NN_NOEXCEPT;
    nn::Result UnregisterSocketDescriptor(std::int32_t socketDescriptor) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nifm::detail::IRequest))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestState, (::nn::sf::Out<::std::int32_t> outRequestState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequestState, (outRequestState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEventReadableHandles, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle1, ::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle2))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemEventReadableHandles, (outSystemEventReadableHandle1, outSystemEventReadableHandle2));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Cancel);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Submit)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Submit);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirement, (const ::nn::nifm::Requirement& requirement))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRequirement, (requirement));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirementPreset, (::std::int32_t requirementPreset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRequirementPreset, (requirementPreset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPriority, (::std::uint8_t priority))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPriority, (priority));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkProfileId, (const ::nn::util::Uuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNetworkProfileId, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRejectable, (bool isRejectable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRejectable, (isRejectable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetConnectionConfirmationOption, (::std::int8_t connectionConfirmationOption))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetConnectionConfirmationOption, (connectionConfirmationOption));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPersistent, (bool isPersistent))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPersistent, (isPersistent));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInstant, (bool isInstant))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInstant, (isInstant));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSustainable, (bool isSustainable, ::std::uint8_t priority))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSustainable, (isSustainable, priority));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRawPriority, (::std::uint8_t rawPriority))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRawPriority, (rawPriority));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetGreedy, (bool isGreedy))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetGreedy, (isGreedy));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSharable, (bool isSharable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSharable, (isSharable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirementByRevision, (::std::uint32_t revision))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetRequirementByRevision, (revision));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequirement, (::nn::sf::Out<::nn::nifm::Requirement> outRequirement))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequirement, (outRequirement));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRevision, (::nn::sf::Out<::std::uint32_t> outRevision))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRevision, (outRevision));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAppletInfo, (::nn::sf::Out<::nn::Bit32> outAppletId, ::nn::sf::Out<::nn::Bit32> outLibraryAppletmode, ::nn::sf::Out<::std::uint32_t> outSize, const ::nn::sf::OutBuffer& outBuffer, ::std::uint32_t colorIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAppletInfo, (outAppletId, outLibraryAppletmode, outSize, outBuffer, colorIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAdditionalInfo, (::nn::sf::Out<::nn::nifm::AdditionalInfo> outAdditionalInfo, ::nn::sf::Out<::std::uint32_t> outRevision))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAdditionalInfo, (outAdditionalInfo, outRevision));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetKeptInSleep, (bool isKeptInSleep))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetKeptInSleep, (isKeptInSleep));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSocketDescriptor, (::std::int32_t socketDescriptor))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterSocketDescriptor, (socketDescriptor));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterSocketDescriptor, (::std::int32_t socketDescriptor))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterSocketDescriptor, (socketDescriptor));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nifm::detail::IRequest>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nifm::detail::IRequest))

    // nn::Result GetRequestState(nn::sf::Out<std::int32_t> outRequestState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequestState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRequestState, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outRequestState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRequestState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequestState)

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetResult)

    // nn::Result GetSystemEventReadableHandles(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle1, nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle2) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemEventReadableHandles)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outSystemEventReadableHandle1, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outSystemEventReadableHandle2, 1, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(2, (outSystemEventReadableHandle1, outSystemEventReadableHandle2))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSystemEventReadableHandle1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSystemEventReadableHandle2)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemEventReadableHandles)

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Cancel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Cancel)

    // nn::Result Submit() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Submit)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Submit)

    // nn::Result SetRequirement(const nn::nifm::Requirement& requirement) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRequirement)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requirement, (::nn::nifm::Requirement), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (requirement))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(36)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requirement)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRequirement)

    // nn::Result SetRequirementPreset(std::int32_t requirementPreset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRequirementPreset)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requirementPreset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (requirementPreset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requirementPreset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRequirementPreset)

    // nn::Result SetPriority(std::uint8_t priority) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPriority)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(priority, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (priority))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(priority)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPriority)

    // nn::Result SetNetworkProfileId(const nn::util::Uuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNetworkProfileId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::util::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNetworkProfileId)

    // nn::Result SetRejectable(bool isRejectable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRejectable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isRejectable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isRejectable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isRejectable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRejectable)

    // nn::Result SetConnectionConfirmationOption(std::int8_t connectionConfirmationOption) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetConnectionConfirmationOption)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionConfirmationOption, (::std::int8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionConfirmationOption))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionConfirmationOption)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetConnectionConfirmationOption)

    // nn::Result SetPersistent(bool isPersistent) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPersistent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPersistent, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isPersistent))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPersistent)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPersistent)

    // nn::Result SetInstant(bool isInstant) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInstant)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isInstant, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isInstant))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isInstant)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInstant)

    // nn::Result SetSustainable(bool isSustainable, std::uint8_t priority) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSustainable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isSustainable, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(priority, (::std::uint8_t), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isSustainable, priority))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSustainable), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(priority)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSustainable)

    // nn::Result SetRawPriority(std::uint8_t rawPriority) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRawPriority)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rawPriority, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rawPriority))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rawPriority)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRawPriority)

    // nn::Result SetGreedy(bool isGreedy) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetGreedy)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isGreedy, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isGreedy))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isGreedy)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetGreedy)

    // nn::Result SetSharable(bool isSharable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSharable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isSharable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isSharable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isSharable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSharable)

    // nn::Result SetRequirementByRevision(std::uint32_t revision) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetRequirementByRevision)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(revision, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (revision))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(revision)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetRequirementByRevision)

    // nn::Result GetRequirement(nn::sf::Out<nn::nifm::Requirement> outRequirement) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequirement)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRequirement, (::nn::nifm::Requirement), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outRequirement))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(36)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRequirement)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequirement)

    // nn::Result GetRevision(nn::sf::Out<std::uint32_t> outRevision) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRevision)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRevision, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outRevision))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRevision)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRevision)

    // nn::Result GetAppletInfo(nn::sf::Out<nn::Bit32> outAppletId, nn::sf::Out<nn::Bit32> outLibraryAppletmode, nn::sf::Out<std::uint32_t> outSize, const nn::sf::OutBuffer& outBuffer, std::uint32_t colorIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAppletInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(colorIndex, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (colorIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAppletId, (::nn::Bit32), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLibraryAppletmode, (::nn::Bit32), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outAppletId, outLibraryAppletmode, outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAppletId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLibraryAppletmode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(colorIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAppletInfo)

    // nn::Result GetAdditionalInfo(nn::sf::Out<nn::nifm::AdditionalInfo> outAdditionalInfo, nn::sf::Out<std::uint32_t> outRevision) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAdditionalInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outAdditionalInfo, 0, (::nn::sf::Out<::nn::nifm::AdditionalInfo>), 1040, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAdditionalInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRevision, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outRevision))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAdditionalInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRevision)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAdditionalInfo)

    // nn::Result SetKeptInSleep(bool isKeptInSleep) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetKeptInSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isKeptInSleep, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isKeptInSleep))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isKeptInSleep)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetKeptInSleep)

    // nn::Result RegisterSocketDescriptor(std::int32_t socketDescriptor) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterSocketDescriptor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(socketDescriptor, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (socketDescriptor))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(socketDescriptor)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterSocketDescriptor)

    // nn::Result UnregisterSocketDescriptor(std::int32_t socketDescriptor) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterSocketDescriptor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(socketDescriptor, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (socketDescriptor))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(socketDescriptor)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterSocketDescriptor)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::Requirement), 36, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::util::Uuid), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nifm::AdditionalInfo), 1040, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nifm::detail::IRequest, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nifm::detail::IRequest))

    // nn::Result GetRequestState(nn::sf::Out<std::int32_t> outRequestState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestState, (::nn::sf::Out<::std::int32_t> outRequestState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequestState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRequestState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequestState)
    }

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetResult)
    }

    // nn::Result GetSystemEventReadableHandles(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle1, nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle2) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEventReadableHandles, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle1, ::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle2))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemEventReadableHandles)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSystemEventReadableHandle1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSystemEventReadableHandle2)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemEventReadableHandles)
    }

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Cancel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Cancel)
    }

    // nn::Result Submit() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Submit)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Submit)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Submit)
    }

    // nn::Result SetRequirement(const nn::nifm::Requirement& requirement) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirement, (const ::nn::nifm::Requirement& requirement))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRequirement)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requirement)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRequirement)
    }

    // nn::Result SetRequirementPreset(std::int32_t requirementPreset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirementPreset, (::std::int32_t requirementPreset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRequirementPreset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requirementPreset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRequirementPreset)
    }

    // nn::Result SetPriority(std::uint8_t priority) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPriority, (::std::uint8_t priority))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPriority)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(priority)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPriority)
    }

    // nn::Result SetNetworkProfileId(const nn::util::Uuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkProfileId, (const ::nn::util::Uuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNetworkProfileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNetworkProfileId)
    }

    // nn::Result SetRejectable(bool isRejectable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRejectable, (bool isRejectable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRejectable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isRejectable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRejectable)
    }

    // nn::Result SetConnectionConfirmationOption(std::int8_t connectionConfirmationOption) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetConnectionConfirmationOption, (::std::int8_t connectionConfirmationOption))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetConnectionConfirmationOption)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionConfirmationOption)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetConnectionConfirmationOption)
    }

    // nn::Result SetPersistent(bool isPersistent) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPersistent, (bool isPersistent))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPersistent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPersistent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPersistent)
    }

    // nn::Result SetInstant(bool isInstant) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInstant, (bool isInstant))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInstant)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isInstant)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInstant)
    }

    // nn::Result SetSustainable(bool isSustainable, std::uint8_t priority) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSustainable, (bool isSustainable, ::std::uint8_t priority))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSustainable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSustainable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(priority)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSustainable)
    }

    // nn::Result SetRawPriority(std::uint8_t rawPriority) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRawPriority, (::std::uint8_t rawPriority))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRawPriority)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rawPriority)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRawPriority)
    }

    // nn::Result SetGreedy(bool isGreedy) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetGreedy, (bool isGreedy))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetGreedy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isGreedy)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetGreedy)
    }

    // nn::Result SetSharable(bool isSharable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSharable, (bool isSharable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSharable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isSharable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSharable)
    }

    // nn::Result SetRequirementByRevision(std::uint32_t revision) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetRequirementByRevision, (::std::uint32_t revision))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetRequirementByRevision)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(revision)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetRequirementByRevision)
    }

    // nn::Result GetRequirement(nn::sf::Out<nn::nifm::Requirement> outRequirement) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequirement, (::nn::sf::Out<::nn::nifm::Requirement> outRequirement))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequirement)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRequirement)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequirement)
    }

    // nn::Result GetRevision(nn::sf::Out<std::uint32_t> outRevision) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRevision, (::nn::sf::Out<::std::uint32_t> outRevision))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRevision)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRevision)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRevision)
    }

    // nn::Result GetAppletInfo(nn::sf::Out<nn::Bit32> outAppletId, nn::sf::Out<nn::Bit32> outLibraryAppletmode, nn::sf::Out<std::uint32_t> outSize, const nn::sf::OutBuffer& outBuffer, std::uint32_t colorIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAppletInfo, (::nn::sf::Out<::nn::Bit32> outAppletId, ::nn::sf::Out<::nn::Bit32> outLibraryAppletmode, ::nn::sf::Out<::std::uint32_t> outSize, const ::nn::sf::OutBuffer& outBuffer, ::std::uint32_t colorIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAppletInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAppletId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLibraryAppletmode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(colorIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAppletInfo)
    }

    // nn::Result GetAdditionalInfo(nn::sf::Out<nn::nifm::AdditionalInfo> outAdditionalInfo, nn::sf::Out<std::uint32_t> outRevision) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAdditionalInfo, (::nn::sf::Out<::nn::nifm::AdditionalInfo> outAdditionalInfo, ::nn::sf::Out<::std::uint32_t> outRevision))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAdditionalInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAdditionalInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRevision)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAdditionalInfo)
    }

    // nn::Result SetKeptInSleep(bool isKeptInSleep) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetKeptInSleep, (bool isKeptInSleep))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetKeptInSleep)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isKeptInSleep)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetKeptInSleep)
    }

    // nn::Result RegisterSocketDescriptor(std::int32_t socketDescriptor) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSocketDescriptor, (::std::int32_t socketDescriptor))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterSocketDescriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(socketDescriptor)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterSocketDescriptor)
    }

    // nn::Result UnregisterSocketDescriptor(std::int32_t socketDescriptor) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterSocketDescriptor, (::std::int32_t socketDescriptor))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterSocketDescriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(socketDescriptor)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterSocketDescriptor)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nifm::detail::IRequest>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nifm::detail::IRequest))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequestState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequestState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRequestState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemEventReadableHandles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outSystemEventReadableHandle1)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outSystemEventReadableHandle2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemEventReadableHandles)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outSystemEventReadableHandle1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outSystemEventReadableHandle2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Submit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Submit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRequirement)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRequirement)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requirement)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRequirementPreset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRequirementPreset)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requirementPreset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPriority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPriority)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(priority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNetworkProfileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNetworkProfileId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRejectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRejectable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isRejectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetConnectionConfirmationOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetConnectionConfirmationOption)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionConfirmationOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPersistent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPersistent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPersistent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInstant)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInstant)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isInstant)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSustainable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSustainable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isSustainable),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(priority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRawPriority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRawPriority)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rawPriority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetGreedy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetGreedy)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isGreedy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSharable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSharable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isSharable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetRequirementByRevision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetRequirementByRevision)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(revision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequirement)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequirement)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRequirement)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRevision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRevision)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRevision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAppletInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAppletInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAppletId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLibraryAppletmode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(colorIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAdditionalInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAdditionalInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAdditionalInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAdditionalInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRevision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetKeptInSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetKeptInSleep)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isKeptInSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterSocketDescriptor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterSocketDescriptor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(socketDescriptor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterSocketDescriptor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterSocketDescriptor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(socketDescriptor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequestState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemEventReadableHandles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Submit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRequirement)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRequirementPreset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPriority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNetworkProfileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRejectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetConnectionConfirmationOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPersistent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInstant)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSustainable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRawPriority)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetGreedy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSharable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetRequirementByRevision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequirement)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRevision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAppletInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAdditionalInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetKeptInSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterSocketDescriptor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterSocketDescriptor)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nifm::detail::IRequest))

namespace nn { namespace nifm { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IScanRequest, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IScanRequest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Submit)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsProcessing, (::nn::sf::Out<bool> outIsProcessing))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEventReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetChannels, (const ::nn::sf::InArray<::std::int16_t>& scanChannelArray))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IScanRequest)

        ::nn::Result Submit() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Submit);
        }

        ::nn::Result IsProcessing(::nn::sf::Out<bool> outIsProcessing) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsProcessing, (outIsProcessing));
        }

        ::nn::Result GetResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetResult);
        }

        ::nn::Result GetSystemEventReadableHandle(::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemEventReadableHandle, (outSystemEventReadableHandle));
        }

        ::nn::Result SetChannels(const ::nn::sf::InArray<::std::int16_t>& scanChannelArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetChannels, (scanChannelArray));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IScanRequest
    {
    public:
        nn::Result Submit() NN_NOEXCEPT;
        nn::Result IsProcessing(nn::sf::Out<bool> outIsProcessing) NN_NOEXCEPT;
        nn::Result GetResult() NN_NOEXCEPT;
        nn::Result GetSystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT;
        nn::Result SetChannels(const nn::sf::InArray<std::int16_t>& scanChannelArray) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Submit() NN_NOEXCEPT;
    nn::Result IsProcessing(nn::sf::Out<bool> outIsProcessing) NN_NOEXCEPT;
    nn::Result GetResult() NN_NOEXCEPT;
    nn::Result GetSystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT;
    nn::Result SetChannels(const nn::sf::InArray<std::int16_t>& scanChannelArray) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nifm::detail::IScanRequest))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Submit)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Submit);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsProcessing, (::nn::sf::Out<bool> outIsProcessing))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsProcessing, (outIsProcessing));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEventReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemEventReadableHandle, (outSystemEventReadableHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetChannels, (const ::nn::sf::InArray<::std::int16_t>& scanChannelArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetChannels, (scanChannelArray));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nifm::detail::IScanRequest>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nifm::detail::IScanRequest))

    // nn::Result Submit() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Submit)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Submit)

    // nn::Result IsProcessing(nn::sf::Out<bool> outIsProcessing) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsProcessing)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsProcessing, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsProcessing))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsProcessing)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsProcessing)

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetResult)

    // nn::Result GetSystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemEventReadableHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outSystemEventReadableHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outSystemEventReadableHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSystemEventReadableHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemEventReadableHandle)

    // nn::Result SetChannels(const nn::sf::InArray<std::int16_t>& scanChannelArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetChannels)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(scanChannelArray, 0, (const ::nn::sf::InArray<::std::int16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (scanChannelArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(scanChannelArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetChannels)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nifm::detail::IScanRequest, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nifm::detail::IScanRequest))

    // nn::Result Submit() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Submit)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Submit)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Submit)
    }

    // nn::Result IsProcessing(nn::sf::Out<bool> outIsProcessing) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsProcessing, (::nn::sf::Out<bool> outIsProcessing))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsProcessing)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsProcessing)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsProcessing)
    }

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetResult)
    }

    // nn::Result GetSystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outSystemEventReadableHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEventReadableHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outSystemEventReadableHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemEventReadableHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSystemEventReadableHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemEventReadableHandle)
    }

    // nn::Result SetChannels(const nn::sf::InArray<std::int16_t>& scanChannelArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetChannels, (const ::nn::sf::InArray<::std::int16_t>& scanChannelArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetChannels)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(scanChannelArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetChannels)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nifm::detail::IScanRequest>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nifm::detail::IScanRequest))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Submit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Submit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsProcessing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsProcessing)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsProcessing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemEventReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outSystemEventReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemEventReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outSystemEventReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetChannels)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(scanChannelArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetChannels)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(scanChannelArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Submit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsProcessing)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemEventReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetChannels)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nifm::detail::IScanRequest))

namespace nn { namespace nifm { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IStaticService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IStaticService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateGeneralServiceOld, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>> outIGeneralService))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateGeneralService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>> outIGeneralService, ::nn::Bit64 processId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IStaticService)

        ::nn::Result CreateGeneralServiceOld(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>> outIGeneralService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateGeneralServiceOld, (outIGeneralService));
        }

        ::nn::Result CreateGeneralService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>> outIGeneralService, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateGeneralService, (outIGeneralService, processId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IStaticService
    {
    public:
        nn::Result CreateGeneralServiceOld(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IGeneralService>> outIGeneralService) NN_NOEXCEPT;
        nn::Result CreateGeneralService(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IGeneralService>> outIGeneralService, nn::Bit64 processId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateGeneralServiceOld(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IGeneralService>> outIGeneralService) NN_NOEXCEPT;
    nn::Result CreateGeneralService(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IGeneralService>> outIGeneralService, nn::Bit64 processId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nifm::detail::IStaticService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateGeneralServiceOld, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>> outIGeneralService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateGeneralServiceOld, (outIGeneralService));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateGeneralService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>> outIGeneralService, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateGeneralService, (outIGeneralService, processId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nifm::detail::IStaticService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nifm::detail::IStaticService))

    // nn::Result CreateGeneralServiceOld(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IGeneralService>> outIGeneralService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateGeneralServiceOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outIGeneralService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outIGeneralService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIGeneralService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateGeneralServiceOld)

    // nn::Result CreateGeneralService(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IGeneralService>> outIGeneralService, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateGeneralService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outIGeneralService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outIGeneralService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIGeneralService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateGeneralService)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nifm::detail::IStaticService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nifm::detail::IStaticService))

    // nn::Result CreateGeneralServiceOld(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IGeneralService>> outIGeneralService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateGeneralServiceOld, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>> outIGeneralService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateGeneralServiceOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIGeneralService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateGeneralServiceOld)
    }

    // nn::Result CreateGeneralService(nn::sf::Out<nn::sf::SharedPointer<nn::nifm::detail::IGeneralService>> outIGeneralService, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateGeneralService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>> outIGeneralService, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateGeneralService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIGeneralService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateGeneralService)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nifm::detail::IStaticService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nifm::detail::IStaticService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateGeneralServiceOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>), outIGeneralService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateGeneralServiceOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outIGeneralService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outIGeneralService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateGeneralService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nifm::detail::IGeneralService>), outIGeneralService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateGeneralService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outIGeneralService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outIGeneralService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateGeneralServiceOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateGeneralService)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nifm::detail::IStaticService))
