﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nn_StaticAssert.h>

#include <nn/util/util_Uuid.h>
#include <nn/nifm/nifm_TypesNetwork.h>
#include <nn/nifm/nifm_TypesRequest.h>
#include <nn/nifm/nifm_TypesRequirement.h>


namespace nn
{
namespace nifm
{
namespace detail
{

using IntNetworkType = int32_t;
NN_STATIC_ASSERT( NetworkType_Count <= INT32_MAX );

using IntRequestState = int32_t;
NN_STATIC_ASSERT( RequestState_Count <= INT32_MAX );

// 提出されている複数の利用要求を統合して、システムが実現するべき接続状態を表現したもの
// 現在の実装では、提出されているうちもっとも優先度の高い利用要求に従う
struct AggregatedRequestType
{
    uint8_t priority;                                               // 統合リクエストに採用された利用要求の優先度
    NetworkType networkType;                                        // 統合リクエストに採用された利用要求のネットワーク種別
    nn::util::Uuid profileId;                                       // 統合リクエストに採用された利用要求が指定したネットワーク種別 （InvalidUuid の場合は指定なし）
    ConnectionConfirmationOption connectionConfirmationOption;      // 統合リクエストに採用された利用要求の疎通確認要求（一度実行済みの場合は丸められていることがある）
    ConnectionConfirmationOption connectionConfirmationOptionSub;   // 相乗り可能な利用要求の疎通確認要求のうち、もっとも強いもの
    uint32_t revision;                                              // 統合リクエストに採用された利用要求のリビジョン

    bool isGreedy;                                                  // 相乗り可能な利用要求のうち、isGreedy と isSharable の
    bool isSharable;                                                // 最も厳しい組み合わせ
    uint32_t restrictedRevision;                                    // 上記の組み合わせを持つ利用要求のリビジョン

    bool isAcceptedRejectable;                                      // 現在の受理済み利用要求の中に却下拒否のものがあるか
    uint32_t lastRevision;                                          // リクエストを統合した際の最新リビジョン

    bool isForeground;                                              // 統合リクエストに採用された利用要求がフォアグラウンドから出されたか否か
    bool isInternalContextUpdatable;                                // 統合リクエストに採用された利用要求がテレメトリコンテキスト更新に影響するか否か

    friend bool operator==(const AggregatedRequestType& lhs, const AggregatedRequestType& rhs) NN_NOEXCEPT
    {
        return lhs.priority == rhs.priority &&
               lhs.networkType == rhs.networkType &&
               lhs.profileId == rhs.profileId &&
               lhs.connectionConfirmationOption == rhs.connectionConfirmationOption &&
               lhs.connectionConfirmationOptionSub == rhs.connectionConfirmationOptionSub &&
               lhs.revision == rhs.revision &&
               lhs.isGreedy == rhs.isGreedy &&
               lhs.isSharable == rhs.isSharable &&
               lhs.restrictedRevision == rhs.restrictedRevision &&
               lhs.isAcceptedRejectable == rhs.isAcceptedRejectable &&
               lhs.lastRevision == rhs.lastRevision &&
               lhs.isForeground == rhs.isForeground;
    }

    friend bool operator!=(const AggregatedRequestType& lhs, const AggregatedRequestType& rhs) NN_NOEXCEPT
    {
        return !(lhs == rhs);
    }
};

extern const AggregatedRequestType InvalidAggregatedRequestType;

struct SocketInfo
{
    int socketDescriptor;
    Bit64 processId;
};


static const int Wep40KeyLength = 5;
static const int Wep40KeyLengthAsHex = Wep40KeyLength * 2;
static const int Wep104KeyLength = 13;
static const int Wep104KeyLengthAsHex = Wep104KeyLength * 2;

static const int LibraryAppletArgumentBufferSize = 4 * 1024;
static const int32_t LibraryAppletArgumentBufferSentinel = UINT32_MAX;

}
}
}

