﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>
#include <nn/os/os_SystemEvent.h>


namespace nn
{
namespace nifm
{
namespace detail
{

/**
* @brief スキャン要求を表します。
*/
class ScanRequestClient
{
    NN_DISALLOW_COPY(ScanRequestClient);
    NN_DISALLOW_MOVE(ScanRequestClient);

private:
    nn::sf::SharedPointer<detail::IScanRequest> m_pIScanRequest;

    nn::os::SystemEvent m_SystemEvent;

public:
    explicit ScanRequestClient(nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;
    ~ScanRequestClient() NN_NOEXCEPT;

    /**
     * @brief 要求を提出します。
     */
    void Submit() NN_NOEXCEPT;

    /**
     * @brief スキャン要求の状態を取得します。
     */
    bool IsProcessing() NN_NOEXCEPT;

    /**
     * @brief スキャン要求の結果を取得します。
     */
    nn::Result GetResult() NN_NOEXCEPT;

    /**
     * @brief スキャン要求の状態変化を待ち受けるためのシステムイベントを取得します。
     */
    nn::os::SystemEvent& GetSystemEvent() NN_NOEXCEPT;

    /**
     * @brief スキャン要求のチャンネルを設定します。
     */
    nn::Result SetChannels(const int16_t scanChennels[], int count) NN_NOEXCEPT;
};

}
}
}

