﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfc/detail/nfc_IUser.h>
#include <nn/nfc/detail/nfc_ISystem.h>
#include <nn/nfp/detail/nfp_IDebug.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/nfc/server/core/nfc_CoreService.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_PrivateResult.h>
#include <nn/nfc/nfc_Result.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_NfpResult.internal.h>

namespace nn {
namespace nfc {
namespace server {

class CommonImpl
{
public:
    CommonImpl() NN_NOEXCEPT;
    ~CommonImpl() NN_NOEXCEPT;

    //Nfc
    nn::Result InitializeNfc(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
    nn::Result FinalizeNfc() NN_NOEXCEPT;
    nn::Result GetStateNfc(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
    nn::Result IsNfcEnabledNfc(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT;
    nn::Result SetNfcEnabledNfc(bool isNfcEnabled) NN_NOEXCEPT;

    //Nfp
    nn::Result InitializeNfp(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
    nn::Result FinalizeNfp() NN_NOEXCEPT;
    nn::Result ListDevicesNfp(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result StartDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StopDetectionNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result MountNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 modelType, nn::Bit32 mountTarget) NN_NOEXCEPT;
    nn::Result UnmountNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result OpenApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 accessId) NN_NOEXCEPT;
    nn::Result GetApplicationAreaNfp(const nn::sf::OutBuffer& buffer, nn::sf::Out<std::uint32_t> size, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result FlushNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result RestoreNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result CreateApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 accessId, const nn::sf::InBuffer& initialData) NN_NOEXCEPT;
    nn::Result GetTagInfoNfp(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetRegisterInfoNfp(nn::sf::Out<nn::nfp::RegisterInfo> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetCommonInfoNfp(nn::sf::Out<nn::nfp::CommonInfo> commonInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetModelInfoNfp(nn::sf::Out<nn::nfp::ModelInfo> modelInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetActivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetDeactivateEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetStateNfp(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
    nn::Result GetDeviceStateNfp(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadIdNfp(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetApplicationAreaSizeNfp(nn::sf::Out<std::uint32_t> size, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAvailabilityChangeEventHandleNfp(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result RecreateApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 accessId, const nn::sf::InBuffer& initialData) NN_NOEXCEPT;
    nn::Result FormatNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAdminInfoNfp(nn::sf::Out<nn::nfp::AdminInfo> adminInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetRegisterInfoPrivateNfp(nn::sf::Out<nn::nfp::RegisterInfoPrivate> registerInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetRegisterInfoPrivateNfp(nn::nfc::DeviceHandle deviceHandle, const nn::nfp::RegisterInfoPrivate& registerInfo) NN_NOEXCEPT;
    nn::Result DeleteRegisterInfoNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result DeleteApplicationAreaNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result ExistsApplicationAreaNfp(nn::sf::Out<bool> flag, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAllNfp(nn::sf::Out<nn::nfp::NfpData> nfpData, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetAllNfp(nn::nfc::DeviceHandle deviceHandle, const nn::nfp::NfpData& nfpData) NN_NOEXCEPT;
    nn::Result FlushDebugNfp(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result BreakTagNfp(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 breakType) NN_NOEXCEPT;
    nn::Result ReadBackupDataNfp(const nn::sf::OutBuffer& buffer, nn::sf::Out<std::uint32_t> size) NN_NOEXCEPT;
    nn::Result WriteBackupDataNfp(const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result WriteNtfNfp(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InBuffer& data, nn::Bit32 ntfWriteType) NN_NOEXCEPT;

    //Mifare
    nn::Result InitializeNfcMifare(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
    nn::Result FinalizeNfcMifare() NN_NOEXCEPT;
    nn::Result ListDevicesNfcMifare(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result StartDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result StopDetectionNfcMifare(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result ReadNfcMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT;
    nn::Result WriteNfcMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT;
    nn::Result GetTagInfoNfcMifare(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetActivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetDeactivateEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetStateNfcMifare(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
    nn::Result GetDeviceStateNfcMifare(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadIdNfcMifare(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAvailabilityChangeEventHandleNfcMifare(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;

    //Common
    nn::Result Initialize(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
    nn::Result IsNfcEnabled(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT;
    nn::Result ListDevices(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result GetDeviceState(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadId(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAvailabilityChangeEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result StartDetection(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 protocolFilter) NN_NOEXCEPT;
    nn::Result StopDetection(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetTagInfo(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetActivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetDeactivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SetNfcEnabled(bool isNfcEnabled) NN_NOEXCEPT;
    nn::Result ReadMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT;
    nn::Result WriteMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT;
    nn::Result SendCommandByPassThrough(const nn::sf::OutBuffer& buffer, nn::sf::Out<std::uint32_t> size, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InBuffer& data, nn::TimeSpan timeout) NN_NOEXCEPT;
    nn::Result KeepPassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result ReleasePassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;

private:
    nn::Result Convert(nn::Result result) NN_NOEXCEPT;
    nn::Result InitializeCommon(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;

protected:
    bool m_IsInitialized;
    nn::nfc::server::core::Service m_Service;
};

}  // server
}  // nfc
}  // nn
