﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/os/os_Tick.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/nfc/nfc_MifareTypes.h>
#include <nn/nfc/server/core/nfc_CoreService.h>

namespace nn { namespace nfc { namespace server {
    class Device;
}}}

namespace nn { namespace nfc { namespace mifare { namespace server {

class Device
{
public:
    explicit Device(nn::nfc::server::Device* device) NN_NOEXCEPT;
    ~Device() NN_NOEXCEPT;
    nn::Result Read(nn::nfc::MifareReadBlockData* pOutBlockData, nn::nfc::server::core::Service* service, const nn::nfc::MifareReadBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT;
    nn::Result Write(nn::nfc::server::core::Service* service, const nn::nfc::MifareWriteBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT;

private:
    Device() NN_NOEXCEPT;

private:
    nn::nfc::server::Device* m_Device;
};

}}}}  // namespace nn::nfc::mifare::server
