﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/news_Types.h>
#include <nn/account/account_Types.h>

namespace nn { namespace news {

/*!
    @name 初期化
    @{
*/

/*!
    @brief      ライブラリの初期化を行います。

    @details
                本ライブラリの API はライブラリの初期化が行われていなかった場合、ライブラリの初期化を行います。@n
                ライブラリの初期化を事前に行うことで、アプリの設定に由来する初期化エラーを即座に検知できるようになります。

                本関数は複数回呼び出しても問題ありません。
*/
void Initialize() NN_NOEXCEPT;

/*!
    @}
*/

}}
