﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace news { namespace detail { namespace service {

/*!
    @brief      ケイパビリティです。

    @details
                API の権限管理を行うために利用します。
*/
class Capability
{
public:
    /*!
        @brief      ケイパビリティフラグです。
    */
    enum Flag : Bit32
    {
        Flag_Post       = 0x00000001, //!< 投稿権限。
        Flag_Config     = 0x00000002, //!< 設定変更権限。
        Flag_View       = 0x00000004, //!< 閲覧権限。
        Flag_Management = 0x00000008, //!< 管理権限。
        Flag_Debug      = 0x00000010, //!< デバッグ権限。
        Flag_All        = 0xFFFFFFFF  //!< 全権。
    };

public:
    /*!
        @brief      コンストラクタです。

        @param[in]  flags   ケイパビリティフラグ。
    */
    NN_IMPLICIT Capability(Bit32 flags) NN_NOEXCEPT
    {
        m_Flags = flags;
    }

    /*!
        @brief      許可されているかどうかを確認します。

        @param[in]  flags   ケイパビリティフラグ。

        @return     許可されているかどうか。

        @details
                    複数のケイパビリティフラグを指定した場合、いずれかのフラグが立っていれば true を返します。
    */
    bool IsPermitted(Bit32 flags) const NN_NOEXCEPT
    {
        return (m_Flags & flags) != 0;
    }

private:
    //
    Bit32 m_Flags;
};

}}}}
