﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      ニュースのダウンローダースレッドです。
*/
class DownloaderThread
{
public:
    /*!
        @brief      スレッドの実行を開始します。
    */
    static void Start() NN_NOEXCEPT;

    /*!
        @brief      スレッドの実行を終了します。
    */
    static void Stop() NN_NOEXCEPT;

    /*!
        @brief      次回のスケジュールまでの時間間隔を取得します。

        @param[out] outInterval 次回のスケジュールまでの時間間隔。

        @return     スケジュールする必要があるかどうか。

        @pre
            - outInterval != nullptr
    */
    static bool GetNextScheduleInterval(nn::TimeSpan* outInterval) NN_NOEXCEPT;

    /*!
        @brief      NPNS の接続を通知します。
    */
    static void NotifyNpnsConnected() NN_NOEXCEPT;

    /*!
        @brief      ネットワークの接続を通知します。
    */
    static void NotifyNetworkConnected() NN_NOEXCEPT;

    /*!
        @brief      システムの実行可能状態の変更を通知します。

        @param[in]  isRunnable  実行可能かどうか。
    */
    static void NotifySystemRunnableStateChanged(bool isRunnable) NN_NOEXCEPT;
};

}}}}}
