﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/ipc/news_IpcService.h>
#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>

namespace nn { namespace news { namespace detail {

/*!
    @brief      シムライブラリのグローバルインスタンスです。

    @details
                シムライブラリのファイル間共通データを管理します。
*/
class ShimLibraryGlobal
{
private:
    /*!
        @brief      コンストラクタです。
    */
    ShimLibraryGlobal() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static ShimLibraryGlobal& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ShimLibraryGlobal, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      インスタンスを初期化します。
    */
    void Initialize() NN_NOEXCEPT;

    /*!
        @brief      セッションを取得します。

        @return     セッション。
    */
    detail::ipc::INewsService* GetSession() NN_NOEXCEPT;

    /*!
        @brief      新着イベントを登録します。

        @param[out] outEvent    新着イベント。

        @return     処理結果。
    */
    nn::Result RegisterNewlyArrivedEvent(nn::os::SystemEvent* outEvent) NN_NOEXCEPT;

    /*!
        @brief      上書きイベントを登録します。

        @param[out] outEvent    上書きイベント。

        @return     処理結果。
    */
    nn::Result RegisterOverwriteEvent(nn::os::SystemEvent* outEvent) NN_NOEXCEPT;

    /*!
        @brief      NewsDataService を作成します。

        @param[out] outService  NewsDataService。

        @return     処理結果。
    */
    nn::Result CreateNewsDataService(detail::ipc::INewsDataService** outService) NN_NOEXCEPT;

    /*!
        @brief      NewsDatabaseService を作成します。

        @param[out] outService  NewsDatabaseService。

        @return     処理結果。
    */
    nn::Result CreateNewsDatabaseService(detail::ipc::INewsDatabaseService** outService) NN_NOEXCEPT;

private:
    //
    nn::os::SdkMutex m_Mutex;
    //
    detail::ipc::INewsService* m_Session;
    detail::ipc::INewlyArrivedEventHolder* m_NewlyArrivedEventHolder;
    detail::ipc::IOverwriteEventHolder* m_OverwriteEventHolder;

private:
    //
    void CreateIpcSession() NN_NOEXCEPT;
};

}}}
