﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      netdiag モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_NETDIAG_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NETDIAG_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NETDIAG_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NETDIAG_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NETDIAG_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NETDIAG_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(netdiag, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NETDIAG_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Trace, 0, format, args)
#define NN_DETAIL_NETDIAG_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Trace, 1, format, args)
#define NN_DETAIL_NETDIAG_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Trace, 2, format, args)
#define NN_DETAIL_NETDIAG_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Trace, 3, format, args)

#define NN_DETAIL_NETDIAG_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Info, 0, format, args)
#define NN_DETAIL_NETDIAG_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Info, 1, format, args)
#define NN_DETAIL_NETDIAG_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Info, 2, format, args)
#define NN_DETAIL_NETDIAG_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Info, 3, format, args)

#define NN_DETAIL_NETDIAG_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Warn, 0, format, args)
#define NN_DETAIL_NETDIAG_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Warn, 1, format, args)
#define NN_DETAIL_NETDIAG_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Warn, 2, format, args)
#define NN_DETAIL_NETDIAG_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Warn, 3, format, args)

#define NN_DETAIL_NETDIAG_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Error, 0, format, args)
#define NN_DETAIL_NETDIAG_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Error, 1, format, args)
#define NN_DETAIL_NETDIAG_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Error, 2, format, args)
#define NN_DETAIL_NETDIAG_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Error, 3, format, args)

#define NN_DETAIL_NETDIAG_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Fatal, 0, format, args)
#define NN_DETAIL_NETDIAG_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Fatal, 1, format, args)
#define NN_DETAIL_NETDIAG_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Fatal, 2, format, args)
#define NN_DETAIL_NETDIAG_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(netdiag, Fatal, 3, format, args)

#define NN_DETAIL_NETDIAG_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Trace, 0, text, length)
#define NN_DETAIL_NETDIAG_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Trace, 1, text, length)
#define NN_DETAIL_NETDIAG_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Trace, 2, text, length)
#define NN_DETAIL_NETDIAG_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Trace, 3, text, length)

#define NN_DETAIL_NETDIAG_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Info, 0, text, length)
#define NN_DETAIL_NETDIAG_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Info, 1, text, length)
#define NN_DETAIL_NETDIAG_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Info, 2, text, length)
#define NN_DETAIL_NETDIAG_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Info, 3, text, length)

#define NN_DETAIL_NETDIAG_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Warn, 0, text, length)
#define NN_DETAIL_NETDIAG_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Warn, 1, text, length)
#define NN_DETAIL_NETDIAG_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Warn, 2, text, length)
#define NN_DETAIL_NETDIAG_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Warn, 3, text, length)

#define NN_DETAIL_NETDIAG_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Error, 0, text, length)
#define NN_DETAIL_NETDIAG_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Error, 1, text, length)
#define NN_DETAIL_NETDIAG_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Error, 2, text, length)
#define NN_DETAIL_NETDIAG_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Error, 3, text, length)

#define NN_DETAIL_NETDIAG_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Fatal, 0, text, length)
#define NN_DETAIL_NETDIAG_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Fatal, 1, text, length)
#define NN_DETAIL_NETDIAG_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Fatal, 2, text, length)
#define NN_DETAIL_NETDIAG_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(netdiag, Fatal, 3, text, length)
