﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEvent.h>
#include <nn/mmnv/mmnv_Types.h>

namespace nn {
namespace mmnv {

class Request
{
private:
    int m_RequestId;
public:
    nn::Result Initialize(Module id, Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;
    nn::Result Initialize(Module id, Priority priority) NN_NOEXCEPT;

    nn::Result SetAndWait(Setting min, Setting max) NN_NOEXCEPT;
    nn::Result Get(Setting* pCurrent) NN_NOEXCEPT;

    nn::Result Finalize() NN_NOEXCEPT;

    Request()  NN_NOEXCEPT;
    ~Request() NN_NOEXCEPT;
};

}}
