﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 *  @file
 *  @brief Mii画像データベースアクセス定義です。
 *  @details Mii画像データベースのアクセサを定義します。
 */

#include <nn/nn_Result.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/util/util_UuidTypes.h>
#include <nn/mii/mii_Common.h>
#include <nn/mii/mii_PrivateCommon.h>
#include <nn/mii/mii_ImageDatabase.h>

namespace nn { namespace mii {

    /**
     * @brief Mii 画像データベースの強制初期化を行います。
     * @param[out] pResult      データベース読み込み結果を返します。
     * @param[in]  enableFormat データベースに破損があった場合にフォーマットするか
     * @return     処理の結果が返ります。
     * @retval     ResultSuccess           成功しました。
     * @retval     nn::mii::ResultBroken   データベースが破損しています(enableFormat=falseの場合に返ります)
     * @pre        pResult != nullptr
     * @details 通常の初期化処理と変わりませんが、
     *          すでに初期化されている場合には一度終了処理を呼び出した後に初期化を行います。
     *          pResult は、戻り値が ResultSuccess の時のみ有効です。
     */
    nn::Result ForceInitializeImageDatabase(DatabaseResult* pResult, bool enableFormat) NN_NOEXCEPT;

}}
