﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mii/detail/service/mii_ServiceCommon.h>

#include <nn/mii/mii_Common.h>
#include <nn/mii/mii_PrivateCommon.h>
#include <nn/mii/mii_ParamCommon.h>
#include <nn/mii/detail/mii_ImageDatabaseImpl.h>
#include <nn/mii/detail/service/mii_IImageDatabaseService.sfdl.h>

#include <nn/sf/sf_Types.h>

namespace nn
{
namespace mii
{
namespace detail
{

class ServiceProvider;

class ImageDatabaseServiceInterface
{
private:
    ImageDatabaseImpl* m_pImageDatabaseImpl;

    nn::Result CheckDatabaseTestModeEnabled() NN_NOEXCEPT;

public:
    explicit ImageDatabaseServiceInterface(ServiceProvider* pServiceProvider) NN_NOEXCEPT;

    ~ImageDatabaseServiceInterface() NN_NOEXCEPT;

    nn::Result Initialize(nn::sf::Out<int8_t> outDatabaseResult, bool enableFormat) NN_NOEXCEPT;

    nn::Result Reload() NN_NOEXCEPT;

    nn::Result GetCount(nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    nn::Result IsEmpty(nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    nn::Result IsFull(nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    nn::Result GetAttribute(nn::sf::Out<nn::mii::detail::ImageAttributeImpl> outAttribute, int32_t index) NN_NOEXCEPT;

    nn::Result LoadImage(nn::sf::OutBuffer outBuffer, const nn::util::Uuid& uuid) NN_NOEXCEPT;

    nn::Result AddOrUpdateImage(
        nn::sf::Out<int32_t> outIndex,
        int8_t expression, // enum を int8_t で
        int8_t pose, // enum を int8_t で
        int8_t fontRegion, // enum を int8_t で
        nn::mii::Nickname nickname,
        nn::mii::CreateId createId,
        nn::util::Uuid usedUuid, // nullptrだと InvalidUuid を入れる
        nn::sf::InArray<nn::util::Uuid> validUuidArray,
        nn::sf::InBuffer srcBuffer
        ) NN_NOEXCEPT;

    nn::Result DeleteImages(nn::sf::InArray<nn::util::Uuid> uuids) NN_NOEXCEPT;


    // デバッグ用
    nn::Result DeleteFile() NN_NOEXCEPT;

    nn::Result DestroyFile() NN_NOEXCEPT;

    nn::Result ImportFile(nn::sf::InBuffer inBuffer) NN_NOEXCEPT;

    nn::Result ExportFile(nn::sf::Out<int64_t> outSize, nn::sf::OutBuffer outBuffer) NN_NOEXCEPT;

    nn::Result ForceInitialize(nn::sf::Out<int8_t> outDatabaseResult, bool enableFormat) NN_NOEXCEPT;
};

}
}
}
