﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

// IDBE のサイズ
const int IdbeSize = 73824;
// IDBE のハッシュサイズ
const int IdbeHashSize = 32;


// IDBE ファイルのヘッダサイズ
const int IdbeFileHeaderSize = 2;
// IDBE ファイルのサイズ
#define IDBE_FILE_SIZE (IdbeFileHeaderSize + IdbeSize + IdbeHashSize)

// サポートするフォーマットバージョン
const int IdbeSupportFormatVersion = 0;
//// Wii U

// IDBE のサイズ
const int IdbeSizeWup = 73824;
// IDBE のハッシュサイズ
const int IdbeHashSizeWup = 32;

// IDBE ファイルのヘッダサイズ
const int IdbeFileHeaderSizeWup = 2;
// IDBE ファイルのサイズ
#define IDBE_FILE_SIZE_WUP (IdbeFileHeaderSizeWup + IdbeSizeWup + IdbeHashSizeWup)

// サポートするフォーマットバージョン
const int IdbeSupportFormatVersionWup = 0;
//// 3DS

// IDBE のサイズ
const int IdbeSizeCtr = 14000;
// IDBE のハッシュサイズ
const int IdbeHashSizeCtr = 32;

// IDBE ファイルのヘッダサイズ
const int IdbeFileHeaderSizeCtr = 2;
// IDBE ファイルのサイズ
#define IDBE_FILE_SIZE_CTR (IdbeFileHeaderSizeCtr + IdbeSizeCtr + IdbeHashSizeCtr)

// IDBE の短いタイトル名の文字数
const int IdbeShortNameLength = 64;

// IDBE の長いタイトル名の文字数
const int IdbeLongNameLength = 128;

// IDBE のパブリッシャ名の文字数
const int IdbePublisherLength = 64;

// サポートするフォーマットバージョン
const int IdbeSupportFormatVersionCtr = 0;

typedef void CURL;
struct curl_slist;

namespace nn { namespace lidbe {

/*!
    @brief         ダウンロードコンテキストです。
*/
struct DownloadContext
{
    CURL*       pCurl;    //!< Curl オブジェクト。アプリが直接 cleanup してはいけません。
    curl_slist* pHeader;  //!< HTTP ヘッダリスト。
    void*       pBuffer;  //!< アイコンファイルを格納するバッファ。
    size_t      readSize; //!< 読み込んだサイズ。
};

/**
* @brief    Key情報です。
*/
struct IDB_Key
{
    uint64_t    titleID;          //!< タイトルIDです。
    int32_t     titleVersion;     //!< タイトルバージョンです。
    uint8_t     padding[4];       //!< パディングです。
};

/**
* @brief    ソフトウェア情報です。
*/
struct IDB_SoftwareInfo
{
    uint16_t    shortTitle[IdbeShortNameLength];    //!< 短いタイトル名です。
    uint16_t    longTitle[IdbeLongNameLength];      //!< 長いタイトル名です。
    uint16_t    publisher[IdbePublisherLength];     //!< パブリッシャ名です。
};

/**
* @brief    アイコン情報です。
*/
struct IDB_WupIconData
{
    uint8_t      header[18];          //!< アイコン画像(tgaフォーマット)のヘッダーです。
    uint8_t      image[65536];        //!< アイコン画像(tgaフォーマット)のイメージ(128x128 32bit)です。
    uint8_t      footer[26];          //!< アイコン画像(tgaフォーマット)のフッターです。
    uint8_t      padding[4];          //!< データ全体を16の倍数にするためのパディングです。
};

struct IDB_CtrIconData
{
    uint16_t     smallIcon[576];          //!< アイコン画像(小)です。
    uint16_t     bigIcon[2304];           //!< アイコン画像(大)です。
};

/**
* @brief    Wupアイコンデータベースエントリフォーマットです。
*/
struct WupIconDataBase
{
     struct IDB_Key             key;
     uint32_t                   region;
     uint8_t                    rating[16];
     uint32_t                   joinGameId;
     uint64_t                   joinGameModeMask;
     struct IDB_SoftwareInfo    info[16];
     struct IDB_WupIconData     data;
};

/**
* @brief    Ctrアイコンデータベースエントリフォーマットです。
*/
struct CtrIconDataBase
{
    struct IDB_Key             key;
    uint32_t                   region;
    uint8_t                    rating[16];
    uint32_t                   matchMakeGameCode;
    uint64_t                   matchMakeGameCodeBit;
    struct IDB_SoftwareInfo    info[16];
    struct IDB_CtrIconData     data;
};


}}
