﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ドライバライブラリのサスペンド・レジューム機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace lbl {
namespace impl {

//! @name サスペンド・レジューム
//! @{

/**
 * @brief   lbl をサスペンドします。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  lbl がサスペンド状態になります。
 *
 * @details
 *  lbl をサスペンドします。@n
 *  明るさセンサーは省電力モードとなり、自動輝度調整が働かなくなります。@n
 *  サスペンド後もセッションのオープン状態は維持されますが、ハードウェアは省電力状態に移行し、機能が利用できない状態になります。@n
 *  すでにサスペンド状態で本関数を呼び出した場合、何もしません。
 */
void Suspend() NN_NOEXCEPT;

/**
 * @brief   lbl をレジュームします。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  lbl がサスペンド前の状態になります。
 *
 * @details
 *  lbl をレジュームし、サスペンド前の状態に戻します。@n
 *  サスペンド前の状態で本関数を呼び出した場合、何もしません。
 */
void Resume() NN_NOEXCEPT;

//! @}

} // impl
} // lbl
} // nn


