﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリに対して操作を行う API の宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace lbl {
namespace impl {

/**
 * @brief LBL ライブラリを初期化します。
 *
 * @post        ライブラリは初期化済の状態になります。
 * @details     LBL ライブラリを初期化します。
 *              本関数の呼び出し回数はライブラリ内部でカウントされます。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief LBL ライブラリを終了します。
 *
 * @post        ライブラリは初期化前の状態になります。
 * @details     LBL ライブラリを終了します。
 *              ライブラリ初期化を行った回数分、本関数が呼ばれた場合にのみ、
 *              ライブラリが初期化前の状態になります。
 */
void Finalize() NN_NOEXCEPT;

} // impl
} // lbl
} // nn


