﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      lbl モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_LBL_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_LBL_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_LBL_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_LBL_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_LBL_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_LBL_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_LBL_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_LBL_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_LBL_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_LBL_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_LBL_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_LBL_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_LBL_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_LBL_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_LBL_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_LBL_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_LBL_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_LBL_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_LBL_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_LBL_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(lbl, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_LBL_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Trace, 0, format, args)
#define NN_DETAIL_LBL_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Trace, 1, format, args)
#define NN_DETAIL_LBL_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Trace, 2, format, args)
#define NN_DETAIL_LBL_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Trace, 3, format, args)

#define NN_DETAIL_LBL_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Info, 0, format, args)
#define NN_DETAIL_LBL_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Info, 1, format, args)
#define NN_DETAIL_LBL_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Info, 2, format, args)
#define NN_DETAIL_LBL_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Info, 3, format, args)

#define NN_DETAIL_LBL_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Warn, 0, format, args)
#define NN_DETAIL_LBL_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Warn, 1, format, args)
#define NN_DETAIL_LBL_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Warn, 2, format, args)
#define NN_DETAIL_LBL_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Warn, 3, format, args)

#define NN_DETAIL_LBL_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Error, 0, format, args)
#define NN_DETAIL_LBL_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Error, 1, format, args)
#define NN_DETAIL_LBL_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Error, 2, format, args)
#define NN_DETAIL_LBL_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Error, 3, format, args)

#define NN_DETAIL_LBL_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Fatal, 0, format, args)
#define NN_DETAIL_LBL_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Fatal, 1, format, args)
#define NN_DETAIL_LBL_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Fatal, 2, format, args)
#define NN_DETAIL_LBL_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(lbl, Fatal, 3, format, args)

#define NN_DETAIL_LBL_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Trace, 0, text, length)
#define NN_DETAIL_LBL_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Trace, 1, text, length)
#define NN_DETAIL_LBL_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Trace, 2, text, length)
#define NN_DETAIL_LBL_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Trace, 3, text, length)

#define NN_DETAIL_LBL_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Info, 0, text, length)
#define NN_DETAIL_LBL_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Info, 1, text, length)
#define NN_DETAIL_LBL_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Info, 2, text, length)
#define NN_DETAIL_LBL_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Info, 3, text, length)

#define NN_DETAIL_LBL_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Warn, 0, text, length)
#define NN_DETAIL_LBL_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Warn, 1, text, length)
#define NN_DETAIL_LBL_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Warn, 2, text, length)
#define NN_DETAIL_LBL_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Warn, 3, text, length)

#define NN_DETAIL_LBL_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Error, 0, text, length)
#define NN_DETAIL_LBL_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Error, 1, text, length)
#define NN_DETAIL_LBL_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Error, 2, text, length)
#define NN_DETAIL_LBL_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Error, 3, text, length)

#define NN_DETAIL_LBL_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Fatal, 0, text, length)
#define NN_DETAIL_LBL_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Fatal, 1, text, length)
#define NN_DETAIL_LBL_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Fatal, 2, text, length)
#define NN_DETAIL_LBL_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(lbl, Fatal, 3, text, length)
