﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/idle/idle_SystemTypes.h>
#include <nn/idle/detail/idle_IPolicyManagerSystem.sfdl.h>

namespace nn { namespace idle { namespace server {

// IPolicyManagerSystem 実装クラス
class PolicyManagerSystemImpl : public nn::sf::ISharedObject
{
public:
    nn::Result GetAutoPowerDownEvent(nn::sf::Out<nn::sf::NativeHandle> pOutNativeHandle) NN_NOEXCEPT;
    nn::Result EnableIdleStateDetectionGlobally() NN_NOEXCEPT;
    nn::Result DisableIdleStateDetectionGlobally() NN_NOEXCEPT;
    nn::Result SetHandlingContext(const nn::idle::HandlingContext& handlingContext) NN_NOEXCEPT;
    nn::Result LoadAndApplySettings() NN_NOEXCEPT;
    nn::Result ReportUserIsActive() NN_NOEXCEPT;
};

}}} // namespace nn::idle::server
