﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace hid { namespace detail {

#if defined(NN_BUILD_CONFIG_OS_WIN)
#pragma warning(push)
#pragma warning(disable:4201)
#endif

/**
 * @brief       3軸をもつモーションセンサーの生値を表す構造体です。
 * @details     内部実装やデバッグ限定
 *              外部公開禁止
 */
struct SensorDriverState
{
    union
    {
        int32_t v[3];
        struct
        {
            int32_t x;  //!< センサーの x 軸の値
            int32_t y;  //!< センサーの y 軸の値
            int32_t z;  //!< センサーの z 軸の値
        };
    };
};

/**
 * @brief       加速度センサーとジャイロセンサーからなる、6軸モーションセンサーの値を表す構造体です。
 * @details     内部実装やデバッグ限定
 *              外部公開禁止
 */
struct SixAxisSensorDriverState
{
    int64_t sampleNumber;              //!< サンプル番号
    SensorDriverState accelerometer;   //!< 加速度センサーの値
    SensorDriverState gyroscope;       //!< ジャイロセンサーの値
};


/**
 * @brief       6軸センサーのキャリブレーション値を表す構造体です。
 * @details     内部実装やデバッグ限定
 *              外部公開禁止
 */
struct SensorCalibrationValue
{
    SensorDriverState accelerometerOrigin;        //!< 加速度センサーの原点値
    SensorDriverState accelerometerSensitivity;   //!< 加速度センサーの感度
    SensorDriverState gyroscopeOrigin;            //!< ジャイロセンサーの原点値
    SensorDriverState gyroscopeSensitivity;       //!< ジャイロセンサーの感度
};


}}} // namespace nn::hid::detail
