﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_MathTypes.h>

namespace nn { namespace hid { namespace detail {

enum PacketStatus : uint8_t
{
    PacketStatus_Dropped,
    PacketStatus_Received,
};

/**
  * brief      パケットの情報
  */
struct PacketInfo
{
    PacketStatus status;    //!< Packet のステータス
    uint8_t interval;       //!< Packet の受信間隔
};

const int PacketHistoryCount = 8;

/**
  * brief      パケットの受信履歴
  */
struct RxPacketHistory
{
    uint64_t samplingCount;  //!< Packet 受信履歴の累計サンプル数
    PacketInfo history[PacketHistoryCount];  //!< Packet の受信履歴
};

}}} // namespace nn::hid::detail
