﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      hdcp モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_HDCP_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_HDCP_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_HDCP_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_HDCP_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_HDCP_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_HDCP_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hdcp, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_HDCP_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Trace, 0, format, args)
#define NN_DETAIL_HDCP_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Trace, 1, format, args)
#define NN_DETAIL_HDCP_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Trace, 2, format, args)
#define NN_DETAIL_HDCP_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Trace, 3, format, args)

#define NN_DETAIL_HDCP_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Info, 0, format, args)
#define NN_DETAIL_HDCP_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Info, 1, format, args)
#define NN_DETAIL_HDCP_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Info, 2, format, args)
#define NN_DETAIL_HDCP_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Info, 3, format, args)

#define NN_DETAIL_HDCP_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Warn, 0, format, args)
#define NN_DETAIL_HDCP_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Warn, 1, format, args)
#define NN_DETAIL_HDCP_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Warn, 2, format, args)
#define NN_DETAIL_HDCP_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Warn, 3, format, args)

#define NN_DETAIL_HDCP_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Error, 0, format, args)
#define NN_DETAIL_HDCP_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Error, 1, format, args)
#define NN_DETAIL_HDCP_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Error, 2, format, args)
#define NN_DETAIL_HDCP_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Error, 3, format, args)

#define NN_DETAIL_HDCP_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Fatal, 0, format, args)
#define NN_DETAIL_HDCP_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Fatal, 1, format, args)
#define NN_DETAIL_HDCP_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Fatal, 2, format, args)
#define NN_DETAIL_HDCP_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hdcp, Fatal, 3, format, args)

#define NN_DETAIL_HDCP_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Trace, 0, text, length)
#define NN_DETAIL_HDCP_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Trace, 1, text, length)
#define NN_DETAIL_HDCP_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Trace, 2, text, length)
#define NN_DETAIL_HDCP_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Trace, 3, text, length)

#define NN_DETAIL_HDCP_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Info, 0, text, length)
#define NN_DETAIL_HDCP_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Info, 1, text, length)
#define NN_DETAIL_HDCP_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Info, 2, text, length)
#define NN_DETAIL_HDCP_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Info, 3, text, length)

#define NN_DETAIL_HDCP_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Warn, 0, text, length)
#define NN_DETAIL_HDCP_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Warn, 1, text, length)
#define NN_DETAIL_HDCP_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Warn, 2, text, length)
#define NN_DETAIL_HDCP_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Warn, 3, text, length)

#define NN_DETAIL_HDCP_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Error, 0, text, length)
#define NN_DETAIL_HDCP_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Error, 1, text, length)
#define NN_DETAIL_HDCP_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Error, 2, text, length)
#define NN_DETAIL_HDCP_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Error, 3, text, length)

#define NN_DETAIL_HDCP_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Fatal, 0, text, length)
#define NN_DETAIL_HDCP_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Fatal, 1, text, length)
#define NN_DETAIL_HDCP_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Fatal, 2, text, length)
#define NN_DETAIL_HDCP_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hdcp, Fatal, 3, text, length)
