﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_TypesAdmin.h>
#include <nn/friends/friends_Macros.h>

namespace nn { namespace friends {

/*!
    @brief      ユーザーアカウントのプレゼンスビューを扱うクラスです。

    @details
                フレンドから見える自身のプレゼンス情報を参照します。
*/
class UserPresenceView
{
public:
    /*!
        @brief      コンストラクタです。
    */
    UserPresenceView() NN_NOEXCEPT;

    /*!
        @brief      プレゼンスの状態を取得します。

        @return     プレゼンスの状態。

        @details
                    ユーザーアカウントが Open 状態でない場合、本関数は @ref PresenceStatus_Offline を返します。
    */
    PresenceStatus GetStatus() const NN_NOEXCEPT;

    /*!
        @brief      最後に遊んだアプリケーションを取得します。

        @return     最後に遊んだアプリケーション。

        @details
                    ユーザーアカウントが Open 状態の場合、現在遊んでいるアプリケーションとなります。@n
                    ユーザーアカウントが Open 状態でない場合、本関数はキャッシュされた最後に遊んだアプリケーションを返します。
    */
    const ApplicationInfo& GetLastPlayedApplication() const NN_NOEXCEPT;

    /*!
        @brief      最終オンライン時刻を取得します。【廃止予定】

        @return     最終オンライン時刻。

        @deprecated
                    注意：本関数は今後削除されます。@n
                    代わりに、 @ref UserPresenceView::GetLastUpdateTime を使用してください。
    */
    NN_DEPRECATED const nn::time::PosixTime& GetLastOnlineTime() const NN_NOEXCEPT;

    /*!
        @brief      プレゼンスの最終更新時刻を取得します。

        @return     プレゼンスの最終更新時刻。
    */
    const nn::time::PosixTime& GetLastUpdateTime() const NN_NOEXCEPT;

    /*!
        @brief      ゲームモード説明文を取得します。

        @return     ゲームモード説明文。

        @details
                    アプリケーションが設定したゲームモード説明文を取得します。

                    有効なゲームモード説明文が存在しない場合、本関数は空文字列を返します。

        @see
            - UserPresence::SetDescription
    */
    const char* GetDescription() const NN_NOEXCEPT;

private:
    //
    NN_FRIENDS_CLASS_STORAGE(224);
};

}}
