﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_TypesAdmin.h>
#include <nn/friends/friends_Macros.h>

namespace nn { namespace friends {

/*!
    @brief      ブロックしたユーザーを扱うクラスです。

    @details
                あるユーザーアカウントに関するブロックしたユーザーの情報を参照することができます。@n
                複数のユーザーアカウントが同一ユーザーをブロックしていたとしても、ユーザーアカウントごとに参照できる内容は異なります。
*/
class BlockedUser
{
public:
    /*!
        @brief      コンストラクタです。
    */
    BlockedUser() NN_NOEXCEPT;

    /*!
        @brief      ネットワークサービスアカウント ID を取得します。

        @return     ネットワークサービスアカウント ID。
    */
    nn::account::NetworkServiceAccountId GetAccountId() const NN_NOEXCEPT;

    /*!
        @brief      ニックネームを取得します。

        @return     ニックネーム。
    */
    const nn::account::Nickname& GetNickname() const NN_NOEXCEPT;

    /*!
        @brief      ユーザーのプロフィール画像 URL を取得します。

        @param[out] outUrl      プロフィール画像 URL。
        @param[in]  imageSize   画像サイズ。

        @return     処理結果。

        @pre
            - outUrl != nullptr
    */
    nn::Result GetProfileImageUrl(Url* outUrl, ImageSize imageSize) const NN_NOEXCEPT;

    /*!
        @brief      ブロック理由を取得します。

        @return     ブロック理由。
    */
    BlockReason GetBlockReason() const NN_NOEXCEPT;

    /*!
        @brief      ブロックの登録経路を取得します。

        @return     登録経路。

        @details
                    経路情報には、以下が含まれます。

                    - ブロックしたアプリケーションの情報@n
                      ブロック理由が @ref BlockReason_InApp の場合のみ、有効な値が入ります。
                    - ブロックした相手のアプリ内表示名@n
                      ブロック理由が @ref BlockReason_InApp の場合のみ、有効な値が入ります。
                    - ブロックした時刻
    */
    const RouteInfo& GetRouteInfo() const NN_NOEXCEPT;

    /*!
        @brief      有効なデータを保持しているかどうかを確認します。

        @return     有効なデータを保持しているかどうか。
    */
    bool IsValid() const NN_NOEXCEPT;

private:
    //
    NN_FRIENDS_CLASS_STORAGE(512);
};

}}
