﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace friends { namespace detail { namespace util {

/*!
    @brief      16 進数文字列を数値に変換します。

    @param[out] outValue    変換結果。
    @param[in]  hex         16 進数文字列。

    @return     変換できたかどうか。
*/
inline bool HexToNumber(uint64_t* outValue, const char* hex) NN_NOEXCEPT
{
    if (!hex)
    {
        return false;
    }

    while (*hex == ' ')
    {
        hex++;
    }

    if (*hex == '-')
    {
        return false;
    }
    if (*hex == '+')
    {
        hex++;
    }

    // 0x
    if (*hex == '0' && (*(hex + 1) == 'x' || *(hex + 1) == 'X'))
    {
        hex += 2;
    }

    uint64_t value = 0;

    while (*hex != '\0')
    {
        int digit = 0;

        if (*hex >= '0' && *hex <= '9')
        {
            digit = *hex - '0';
        }
        else if (*hex >= 'A' && *hex <= 'F')
        {
            digit = *hex - 'A' + 10;
        }
        else if (*hex >= 'a' && *hex <= 'f')
        {
            digit = *hex - 'a' + 10;
        }
        else
        {
            return false;
        }

        if (value > UINT64_MAX / 16)
        {
            return false;
        }
        if (static_cast<uint64_t>(digit) > UINT64_MAX - value)
        {
            return false;
        }

        value *= 16;
        value += digit;

        hex++;
    }

    *outValue = value;

    return true;
}

}}}}
