﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <atomic>

namespace nn { namespace friends { namespace detail { namespace service { namespace util {

/*!
    @brief      インクリメンタルカウンタークラスです。

    @details
                値が取得される度にカウンターが更新されます。@n
                システムが生存している間、必ず異なる値が取得できます。

                本クラスは、スレッドセーフに動作します。
*/
class IncrementalCounter
{
private:
    NN_DISALLOW_COPY(IncrementalCounter);
    NN_DISALLOW_MOVE(IncrementalCounter);

private:
    /*!
        @brief      コンストラクタです。
    */
    IncrementalCounter() NN_NOEXCEPT : m_Counter(0) {}

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static IncrementalCounter& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(IncrementalCounter, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      値を取得します。

        @return     値。
    */
    uint64_t GetValue() NN_NOEXCEPT
    {
        return ++m_Counter;
    }

private:
    //
    std::atomic<uint64_t> m_Counter;
};

}}}}}
