﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <atomic>

namespace nn { namespace friends { namespace detail { namespace service { namespace util {

/*!
    @brief      キャンセル可能オブジェクトです。
*/
class Cancelable
{
public:
    /*!
        @brief      コンストラクタです。
    */
    Cancelable() NN_NOEXCEPT : m_IsCanceled(false) {}

    /*!
        @brief      キャンセルします。
    */
    void Cancel() NN_NOEXCEPT
    {
        m_IsCanceled = true;
    }

    /*!
        @brief      キャンセルされたかどうかを取得します。

        @return     キャンセルされたかどうか。
    */
    bool IsCanceled() const NN_NOEXCEPT
    {
        return m_IsCanceled;
    }

private:
    //
    std::atomic<bool> m_IsCanceled;
};

}}}}}
