﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/friends/detail/ipc/friends_IServiceCreator.sfdl.h>

namespace nn { namespace friends { namespace detail { namespace service {

/*!
    @brief      サービス生成器の初期化を行います。

    @param[in]  index       インデックス。
    @param[in]  serviceName サービス名。
    @param[in]  capability  ケイパビリティフラグ。

    @pre
        - 0 <= index < detail::ipc::ServiceCount
*/
void InitializeServiceCreator(int index, const char* serviceName, Bit32 capability) NN_NOEXCEPT;

/*!
    @brief      初期化済みのサービス生成器すべての終了処理を行います。
*/
void FinalizeServiceCreators() NN_NOEXCEPT;

/*!
    @brief      サービス生成器を取得します。

    @param[in]  index   インデックス。

    @return     サービス生成器。

    @pre
        - 0 <= index < detail::ipc::ServiceCount

    @details
                指定したインデックスのサービス生成器は事前に作成しておく必要があります。
*/
nn::sf::SharedPointer<detail::ipc::IServiceCreator> GetServiceCreator(int index) NN_NOEXCEPT;

}}}}
