﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/friends_Task.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      対面フレンド申請を送信するタスクです。
*/
class SendFacedFriendRequestTask : public Task
{
public:
    /*!
        @brief      コンストラクタです。
    */
    SendFacedFriendRequestTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  isForeground    フォアグラウンドからの呼び出しかどうか。

        @return     処理結果。
    */
    nn::Result SetParameter(bool isForeground) NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId       相手のネットワークサービスアカウント ID。
        @param[in]  isForeground    フォアグラウンドからの呼び出しかどうか。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId, bool isForeground) NN_NOEXCEPT;

private:
    //
    nn::account::NetworkServiceAccountId m_AccountId;
    bool m_IsAccountIdSpecified;
    //
    bool m_IsForeground;
    nn::Result m_LastSendResult;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepSend() NN_NOEXCEPT;
    nn::Result StepSendImpl(nn::account::NetworkServiceAccountId accountId,
        FacedFriendRequestResource& resource) NN_NOEXCEPT;
    nn::Result CreateSendPostField(nn::account::NetworkServiceAccountId accountId,
        const FacedFriendRequestResource& resource, char* buffer, size_t size) NN_NOEXCEPT;
};

}}}}}
