﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/friends_Task.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      プロフィールリストを取得するタスクです。
*/
class GetProfileListTask : public Task
{
public:
    /*!
        @brief      コンストラクタです。
    */
    GetProfileListTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[out] outProfiles プロフィールリスト。
        @param[in]  accountIds  任意のユーザーのネットワークサービスアカウント ID リスト。
        @param[in]  count       プロフィールリストの要素数。

        @return     処理結果。
    */
    nn::Result SetParameter(ProfileImpl* outProfiles,
        const nn::account::NetworkServiceAccountId* accountIds, int count) NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[out] outProfiles プロフィールリスト。
        @param[in]  accountIds  任意のユーザーのネットワークサービスアカウント ID リスト。
        @param[in]  count       プロフィールリストの要素数。

        @return     処理結果。
    */
    nn::Result SetParameter(ProfileExtraImpl* outProfiles,
        const nn::account::NetworkServiceAccountId* accountIds, int count) NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[out] outProfile  プロフィール。
        @param[in]  friendCode  フレンドコード。

        @return     処理結果。
    */
    nn::Result SetParameter(ProfileExtraImpl* outProfile,
        const FriendCode& friendCode) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    bool m_IsParameterSetWithFriendCode;
    //
    ProfileImpl* m_OutProfiles;
    ProfileExtraImpl* m_OutProfileExtras;
    //
    const nn::account::NetworkServiceAccountId* m_AccountIds;
    int m_Count;
    FriendCode m_FriendCode;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepGetProfile() NN_NOEXCEPT;
    nn::Result StepGetProfileExtra() NN_NOEXCEPT;
    nn::Result StepGetProfileExtraWithFriendCode() NN_NOEXCEPT;
    //
    void GetUniqueArray(int* outCount, nn::account::NetworkServiceAccountId* outAccountIds,
        const nn::account::NetworkServiceAccountId* accountIds, int count) NN_NOEXCEPT;
};

}}}}}
