﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド推薦サーバーのエラーのハンドラです。
*/
class FrsErrorHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      エラー情報です。
    */
    struct ErrorInfo
    {
        char errorCode[5];
    };

    /*!
        @brief      エラー情報のパース結果です。
    */
    struct ErrorInfoParseBits
    {
        Bit64 errorCode : 1;
        Bit64 message : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    FrsErrorHandler() NN_NOEXCEPT;

    /*!
        @brief      ハンドル結果を取得します。

        @return     ハンドル結果。

        @details
                    エラー情報をハンドルしていない場合、成功を返します。
    */
    virtual nn::Result GetResult() const NN_NOEXCEPT NN_OVERRIDE;

public:
    // JsonEventHandler
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    ErrorInfo m_Info;
    ErrorInfoParseBits m_Bits;
};

}}}}}
